% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_env.R
\name{trans_env}
\alias{trans_env}
\title{Create trans_env object for the analysis of the effects of environmental factors on communities.}
\description{
This class is a wrapper for a series of operations associated with environmental measurements, including redundancy analysis, 
mantel test, correlation analysis and linear fitting based on An et al. (2019) <doi:10.1016/j.geoderma.2018.09.035>.
}
\examples{

## ------------------------------------------------
## Method `trans_env$new`
## ------------------------------------------------

data(dataset)
data(env_data_16S)
t1 <- trans_env$new(dataset = dataset, add_data = env_data_16S[, 4:11])

## ------------------------------------------------
## Method `trans_env$cal_diff`
## ------------------------------------------------

\donttest{
t1$cal_diff(group = "Group", method = "KW")
t1$cal_diff(group = "Group", method = "KW_dunn")
t1$cal_diff(group = "Group", method = "anova")
}

## ------------------------------------------------
## Method `trans_env$cal_autocor`
## ------------------------------------------------

\donttest{
t1$cal_autocor(method = "GGally")
}

## ------------------------------------------------
## Method `trans_env$cal_ordination`
## ------------------------------------------------

\donttest{
t1$cal_ordination(method = "dbRDA", use_measure = "bray")
t1$cal_ordination(method = "RDA", taxa_level = "Genus")
t1$cal_ordination(method = "CCA", taxa_level = "Genus")
}

## ------------------------------------------------
## Method `trans_env$cal_ordination_envsquare`
## ------------------------------------------------

\donttest{
t1$cal_ordination_envsquare()
}

## ------------------------------------------------
## Method `trans_env$trans_ordination`
## ------------------------------------------------

\donttest{
t1$trans_ordination(adjust_arrow_length = TRUE, min_perc_env = 0.1, max_perc_env = 1)
}

## ------------------------------------------------
## Method `trans_env$plot_ordination`
## ------------------------------------------------

\donttest{
t1$cal_ordination(method = "RDA")
t1$trans_ordination(adjust_arrow_length = TRUE, max_perc_env = 1.5)
t1$plot_ordination(plot_color = "Group")
t1$plot_ordination(plot_color = "Group", plot_shape = "Group", plot_type = c("point", "ellipse"))
t1$plot_ordination(plot_color = "Group", plot_type = c("point", "chull"))
t1$plot_ordination(plot_color = "Group", plot_type = c("point", "centroid"), 
	  centroid_segment_linetype = 1)
t1$plot_ordination(plot_color = "Group", env_nudge_x = c(0.4, 0, 0, 0, 0, -0.2, 0, 0), 
	  env_nudge_y = c(0.6, 0, 0.2, 0.5, 0, 0.1, 0, 0.2))
}

## ------------------------------------------------
## Method `trans_env$cal_mantel`
## ------------------------------------------------

\donttest{
t1$cal_mantel(use_measure = "bray")
t1$cal_mantel(partial_mantel = TRUE, use_measure = "bray")
}

## ------------------------------------------------
## Method `trans_env$cal_cor`
## ------------------------------------------------

\donttest{
t2 <- trans_diff$new(dataset = dataset, method = "rf", group = "Group", rf_taxa_level = "Genus")
t1 <- trans_env$new(dataset = dataset, add_data = env_data_16S[, 4:11])
t1$cal_cor(use_data = "other", p_adjust_method = "fdr", other_taxa = t2$res_diff$Taxa[1:40])
}

## ------------------------------------------------
## Method `trans_env$plot_cor`
## ------------------------------------------------

\donttest{
t1$plot_cor(pheatmap = FALSE)
}

## ------------------------------------------------
## Method `trans_env$plot_scatterfit`
## ------------------------------------------------

\donttest{
t1$plot_scatterfit(x = 1, y = 2, type = "cor")
t1$plot_scatterfit(x = 1, y = 2, type = "lm", point_alpha = .3)
t1$plot_scatterfit(x = "pH", y = "TOC", type = "lm", group = "Group", line_se = FALSE)
t1$plot_scatterfit(x = 
	 dataset$beta_diversity$bray[rownames(t1$data_env), rownames(t1$data_env)], y = "pH")
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{trans_env$new()}}
\item \href{#method-cal_diff}{\code{trans_env$cal_diff()}}
\item \href{#method-plot_diff}{\code{trans_env$plot_diff()}}
\item \href{#method-cal_autocor}{\code{trans_env$cal_autocor()}}
\item \href{#method-cal_ordination}{\code{trans_env$cal_ordination()}}
\item \href{#method-cal_ordination_envsquare}{\code{trans_env$cal_ordination_envsquare()}}
\item \href{#method-trans_ordination}{\code{trans_env$trans_ordination()}}
\item \href{#method-plot_ordination}{\code{trans_env$plot_ordination()}}
\item \href{#method-cal_mantel}{\code{trans_env$cal_mantel()}}
\item \href{#method-cal_cor}{\code{trans_env$cal_cor()}}
\item \href{#method-plot_cor}{\code{trans_env$plot_cor()}}
\item \href{#method-plot_scatterfit}{\code{trans_env$plot_scatterfit()}}
\item \href{#method-print}{\code{trans_env$print()}}
\item \href{#method-clone}{\code{trans_env$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$new(
  dataset = NULL,
  env_cols = NULL,
  add_data = NULL,
  character2numeric = TRUE,
  complete_na = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{the object of \code{\link{microtable}} Class.}

\item{\code{env_cols}}{default NULL; either numeric vector or character vector to select columns in sample_table of your microtable object. 
This parameter should be used in the case that all the required environmental data is in sample_table of your microtable object.
Otherwise, please use add_data parameter.}

\item{\code{add_data}}{default NULL; data.frame format; provide the environmental data in the format data.frame; rownames should be sample names.
This parameter should be used when the sample_table in your microtable object has no environmental data. 
Under this circumstance, the env_cols parameter can not be used because no data can be selected.}

\item{\code{character2numeric}}{default TRUE; whether transform the characters or factors to numeric attributes.}

\item{\code{complete_na}}{default FALSE; Whether fill the NA (missing value) in the environmental data;
If TRUE, the function can run the interpolation with the mice package; to use this parameter, please first install mice package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
data_env in trans_env object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(dataset)
data(env_data_16S)
t1 <- trans_env$new(dataset = dataset, add_data = env_data_16S[, 4:11])
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_diff"></a>}}
\if{latex}{\out{\hypertarget{method-cal_diff}{}}}
\subsection{Method \code{cal_diff()}}{
Test the difference of environmental variable across groups.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$cal_diff(
  group = NULL,
  method = c("KW", "KW_dunn", "wilcox", "t.test", "anova")[1],
  measure = NULL,
  p_adjust_method = "fdr",
  anova_set = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{group}}{default NULL; a colname of sample_table used to compare values across groups.}

\item{\code{method}}{default "KW"; see the following available options:
\describe{
  \item{\strong{'KW'}}{KW: Kruskal-Wallis Rank Sum Test for all groups (>= 2)}
  \item{\strong{'KW_dunn'}}{Dunn's Kruskal-Wallis Multiple Comparisons, see dunnTest function in FSA package}
  \item{\strong{'wilcox'}}{Wilcoxon Rank Sum and Signed Rank Tests for all paired groups }
  \item{\strong{'t.test'}}{Student's t-Test for all paired groups}
  \item{\strong{'anova'}}{Duncan's multiple range test for anova}
}}

\item{\code{measure}}{default NULL; a vector; if null, all variables will be calculated.}

\item{\code{p_adjust_method}}{default "fdr"; p.adjust method; see method parameter of p.adjust function for available options.}

\item{\code{anova_set}}{default NULL; specified group set for anova, such as 'block + N*P*K', see \code{\link{aov}}.}

\item{\code{...}}{parameters passed to kruskal.test or wilcox.test function (method = "KW") or dunnTest function of FSA package (method = "KW_dunn") or
agricolae::duncan.test (method = "anova").}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_diff in object. A data.frame generally. A list for anova when anova_set is assigned.
  In the data frame, 'Group' column means that the group has the maximum median or mean value across the test groups;
  For non-parametric methods, maximum median value; For t.test, maximum mean value.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_diff(group = "Group", method = "KW")
t1$cal_diff(group = "Group", method = "KW_dunn")
t1$cal_diff(group = "Group", method = "anova")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_diff"></a>}}
\if{latex}{\out{\hypertarget{method-plot_diff}{}}}
\subsection{Method \code{plot_diff()}}{
Plotting values of environmental variables across groups and add the significance label.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$plot_diff(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{parameters passed to plot_alpha of trans_alpha. Please see plot_alpha function of trans_alpha class for all the available parameters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_autocor"></a>}}
\if{latex}{\out{\hypertarget{method-cal_autocor}{}}}
\subsection{Method \code{cal_autocor()}}{
Calculate the autocorrelations among environmental variables and plot the result.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$cal_autocor(
  group = NULL,
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  alpha = 0.8,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{group}}{default NULL; a colname of sample_table; used to perform calculations for different groups.}

\item{\code{color_values}}{default RColorBrewer::brewer.pal(8, "Dark2"); colors palette.}

\item{\code{alpha}}{default 0.8; the alpha value to add transparency in colors; useful when group is not NULL.}

\item{\code{...}}{default parameters passed to GGally::ggpairs.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggmatrix.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_autocor(method = "GGally")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_ordination"></a>}}
\if{latex}{\out{\hypertarget{method-cal_ordination}{}}}
\subsection{Method \code{cal_ordination()}}{
Redundancy analysis (RDA) and Correspondence Analysis (CCA) based on the vegan package.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$cal_ordination(
  method = c("RDA", "dbRDA", "CCA")[1],
  feature_sel = FALSE,
  taxa_level = NULL,
  taxa_filter_thres = NULL,
  use_measure = NULL,
  add_matrix = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{default c("RDA", "dbRDA", "CCA")[1]; the ordination method.}

\item{\code{feature_sel}}{default FALSE; whether perform the feature selection based on forward selection method.}

\item{\code{taxa_level}}{default NULL; If use RDA or CCA, provide the taxonomic rank, such as "Phylum" or "Genus";
If use otu_table; please input "OTU".}

\item{\code{taxa_filter_thres}}{default NULL; If want to filter taxa, provide the relative abundance threshold.}

\item{\code{use_measure}}{default NULL; a name of beta diversity matrix; only useful when parameter method = "dbRDA";
If not provided, use the first beta diversity matrix automatically.}

\item{\code{add_matrix}}{default NULL; additional distance matrix provided, when the user does not want to use the beta diversity matrix within the dataset;
only available when method = "dbRDA".}

\item{\code{...}}{paremeters pass to dbrda or rda or cca function according to the input of method.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_ordination, res_ordination_R2, res_ordination_terms and res_ordination_axis in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_ordination(method = "dbRDA", use_measure = "bray")
t1$cal_ordination(method = "RDA", taxa_level = "Genus")
t1$cal_ordination(method = "CCA", taxa_level = "Genus")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_ordination_envsquare"></a>}}
\if{latex}{\out{\hypertarget{method-cal_ordination_envsquare}{}}}
\subsection{Method \code{cal_ordination_envsquare()}}{
Fits each environmental vector onto the ordination to obtain the contribution of each variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$cal_ordination_envsquare(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{the parameters passing to vegan::envfit function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_ordination_envsquare in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_ordination_envsquare()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_ordination"></a>}}
\if{latex}{\out{\hypertarget{method-trans_ordination}{}}}
\subsection{Method \code{trans_ordination()}}{
transform ordination result for the following plotting.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$trans_ordination(
  show_taxa = 10,
  adjust_arrow_length = FALSE,
  min_perc_env = 0.1,
  max_perc_env = 0.8,
  min_perc_tax = 0.1,
  max_perc_tax = 0.8
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{show_taxa}}{default 10; taxa number shown in the plot.}

\item{\code{adjust_arrow_length}}{default FALSE; whether adjust the arrow length to be clearer.}

\item{\code{min_perc_env}}{default 0.1; used for scaling up the minimum of env arrow; multiply by the maximum distance between samples and origin.}

\item{\code{max_perc_env}}{default 0.8; used for scaling up the maximum of env arrow; multiply by the maximum distance between samples and origin.}

\item{\code{min_perc_tax}}{default 0.1; used for scaling up the minimum of tax arrow; multiply by the maximum distance between samples and origin.}

\item{\code{max_perc_tax}}{default 0.8; used for scaling up the maximum of tax arrow; multiply by the maximum distance between samples and origin.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_ordination_trans in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$trans_ordination(adjust_arrow_length = TRUE, min_perc_env = 0.1, max_perc_env = 1)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_ordination"></a>}}
\if{latex}{\out{\hypertarget{method-plot_ordination}{}}}
\subsection{Method \code{plot_ordination()}}{
plot ordination result.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$plot_ordination(
  plot_color = NULL,
  plot_shape = NULL,
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  shape_values = c(16, 17, 7, 8, 15, 18, 11, 10, 12, 13, 9, 3, 4, 0, 1, 2, 14),
  env_text_color = "black",
  env_arrow_color = "grey30",
  taxa_text_color = "firebrick1",
  taxa_arrow_color = "firebrick1",
  env_text_size = 3.7,
  taxa_text_size = 3,
  taxa_text_italic = TRUE,
  plot_type = "point",
  point_size = 3,
  point_alpha = 0.8,
  centroid_segment_alpha = 0.6,
  centroid_segment_size = 1,
  centroid_segment_linetype = 3,
  ellipse_chull_fill = TRUE,
  ellipse_chull_alpha = 0.1,
  ellipse_level = 0.9,
  ellipse_type = "t",
  add_sample_label = NULL,
  env_nudge_x = NULL,
  env_nudge_y = NULL,
  taxa_nudge_x = NULL,
  taxa_nudge_y = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot_color}}{default NULL; a colname of sample_table to assign colors to different groups in plot.}

\item{\code{plot_shape}}{default NULL; a colname of sample_table to assign shapes to different groups in plot.}

\item{\code{color_values}}{default RColorBrewer::brewer.pal(8, "Dark2"); color pallete for different groups.}

\item{\code{shape_values}}{default c(16, 17, 7, 8, 15, 18, 11, 10, 12, 13, 9, 3, 4, 0, 1, 2, 14); a vector for point shape types of groups, see ggplot2 tutorial.}

\item{\code{env_text_color}}{default "black"; environmental variable text color.}

\item{\code{env_arrow_color}}{default "grey30"; environmental variable arrow color.}

\item{\code{taxa_text_color}}{default "firebrick1"; taxa text color.}

\item{\code{taxa_arrow_color}}{default "firebrick1"; taxa arrow color.}

\item{\code{env_text_size}}{default 3.7; environmental variable text size.}

\item{\code{taxa_text_size}}{default 3; taxa text size.}

\item{\code{taxa_text_italic}}{default TRUE; "italic"; whether use "italic" style for the taxa text in the plot.}

\item{\code{plot_type}}{default "point"; one or more elements of "point", "ellipse", "chull" and "centroid".
\describe{
  \item{\strong{'point'}}{add point}
  \item{\strong{'ellipse'}}{add confidence ellipse for points of each group}
  \item{\strong{'chull'}}{add convex hull for points of each group}
  \item{\strong{'centroid'}}{add centroid line of each group}
}}

\item{\code{point_size}}{default 3; point size in plot when "point" is in plot_type.}

\item{\code{point_alpha}}{default .8; point transparency in plot when "point" is in plot_type.}

\item{\code{centroid_segment_alpha}}{default 0.6; segment transparency in plot when "centroid" is in plot_type.}

\item{\code{centroid_segment_size}}{default 1; segment size in plot when "centroid" is in plot_type.}

\item{\code{centroid_segment_linetype}}{default 3; an integer; the line type related with centroid in plot when "centroid" is in plot_type.}

\item{\code{ellipse_chull_fill}}{default TRUE; whether fill colors to the area of ellipse or chull.}

\item{\code{ellipse_chull_alpha}}{default 0.1; color transparency in the ellipse or convex hull depending on whether "ellipse" or "centroid" is in plot_type.}

\item{\code{ellipse_level}}{default .9; confidence level of ellipse when "ellipse" is in plot_type.}

\item{\code{ellipse_type}}{default "t"; ellipse type when "ellipse" is in plot_type; see type in \code{\link{stat_ellipse}}.}

\item{\code{add_sample_label}}{default NULL; the column name in sample table, if provided, show the point name in plot.}

\item{\code{env_nudge_x}}{default NULL; numeric vector to adjust the env text x axis position; passed to nudge_x parameter of geom_text_repel function of ggrepel package;
default NULL represents automatic adjustment; the length must be same with the row number of object$res_ordination_trans$df_arrows. For example, 
if there are 5 env variables, env_nudge_x should be something like c(0.1, 0, -0.2, 0, 0). 
Note that this parameter and env_nudge_y is generally used when the automatic text adjustment is not very well.}

\item{\code{env_nudge_y}}{default NULL; numeric vector to adjust the env text y axis position; passed to nudge_y parameter of ggrepel::geom_text_repel function;
default NULL represents automatic adjustment; the length must be same with the row number of object$res_ordination_trans$df_arrows. For example, 
if there are 5 env variables, env_nudge_y should be something like c(0.1, 0, -0.2, 0, 0).}

\item{\code{taxa_nudge_x}}{default NULL; numeric vector to adjust the taxa text x axis position; passed to nudge_x parameter of ggrepel::geom_text_repel function;
default NULL represents automatic adjustment; the length must be same with the row number of object$res_ordination_trans$df_arrows_spe. For example, 
if 3 taxa are shown, taxa_nudge_x should be something like c(0.3, -0.2, 0).}

\item{\code{taxa_nudge_y}}{default NULL; numeric vector to adjust the taxa text y axis position; passed to nudge_y parameter of ggrepel::geom_text_repel function;
default NULL represents automatic adjustment; the length must be same with the row number of object$res_ordination_trans$df_arrows_spe. For example, 
if 3 taxa are shown, taxa_nudge_y should be something like c(-0.2, 0, 0.4).}

\item{\code{...}}{paremeters pass to geom_point for controlling sample points.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_ordination(method = "RDA")
t1$trans_ordination(adjust_arrow_length = TRUE, max_perc_env = 1.5)
t1$plot_ordination(plot_color = "Group")
t1$plot_ordination(plot_color = "Group", plot_shape = "Group", plot_type = c("point", "ellipse"))
t1$plot_ordination(plot_color = "Group", plot_type = c("point", "chull"))
t1$plot_ordination(plot_color = "Group", plot_type = c("point", "centroid"), 
	  centroid_segment_linetype = 1)
t1$plot_ordination(plot_color = "Group", env_nudge_x = c(0.4, 0, 0, 0, 0, -0.2, 0, 0), 
	  env_nudge_y = c(0.6, 0, 0.2, 0.5, 0, 0.1, 0, 0.2))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_mantel"></a>}}
\if{latex}{\out{\hypertarget{method-cal_mantel}{}}}
\subsection{Method \code{cal_mantel()}}{
Mantel test between beta diversity matrix and environmental data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$cal_mantel(
  select_env_data = NULL,
  partial_mantel = FALSE,
  add_matrix = NULL,
  use_measure = NULL,
  method = "pearson",
  p_adjust_method = "fdr",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{select_env_data}}{default NULL; numeric or character vector to select columns in data_env; if not provided, automatically select the columns with numeric attributes.}

\item{\code{partial_mantel}}{default FALSE; whether use partial mantel test; If TRUE, use other measurements as the zdis.}

\item{\code{add_matrix}}{default NULL; additional distance matrix provided, if you donot want to use the beta diversity matrix in the dataset.}

\item{\code{use_measure}}{default NULL; name of beta diversity matrix. If necessary and not provided, use the first beta diversity matrix.}

\item{\code{method}}{default "pearson"; one of "pearson", "spearman" and "kendall"; correlation method; see method parameter in mantel function of vegan package.}

\item{\code{p_adjust_method}}{default "fdr"; p.adjust method; see method parameter of p.adjust function for available options.}

\item{\code{...}}{paremeters pass to \code{\link{mantel}} of vegan package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_mantel in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_mantel(use_measure = "bray")
t1$cal_mantel(partial_mantel = TRUE, use_measure = "bray")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_cor"></a>}}
\if{latex}{\out{\hypertarget{method-cal_cor}{}}}
\subsection{Method \code{cal_cor()}}{
Calculating the correlations between taxa abundance and environmental variables.
Actually, it can also be used for calculating other correlation between any two variables from two tables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$cal_cor(
  use_data = c("Genus", "all", "other")[1],
  select_env_data = NULL,
  cor_method = c("pearson", "spearman", "kendall")[1],
  p_adjust_method = "fdr",
  p_adjust_type = c("Type", "Taxa", "Env")[3],
  add_abund_table = NULL,
  by_group = NULL,
  use_taxa_num = NULL,
  other_taxa = NULL,
  group_use = NULL,
  group_select = NULL,
  taxa_name_full = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_data}}{default "Genus"; "Genus", "all" or "other"; "Genus" or other taxonomic name: use genus or other taxonomic abundance table in taxa_abund; 
"all": use all merged taxa abundance table; "other": provide additional taxa name with other_taxa parameter which is necessary.}

\item{\code{select_env_data}}{default NULL; numeric or character vector to select columns in data_env; if not provided, automatically select the columns with numeric attributes.}

\item{\code{cor_method}}{default "pearson"; "pearson", "spearman" or "kendall"; correlation method.}

\item{\code{p_adjust_method}}{default "fdr"; p.adjust method; see method parameter of p.adjust function for available options.}

\item{\code{p_adjust_type}}{default "Env"; "Type", "Taxa" or "Env"; p.adjust type; Env: environmental data; Taxa: taxa data; Type: group used.}

\item{\code{add_abund_table}}{default NULL; additional data table to be used. Samples must be rows.}

\item{\code{by_group}}{default NULL; one column name or number in sample_table; calculate correlations for different groups separately.}

\item{\code{use_taxa_num}}{default NULL; integer; a number used to select high abundant taxa; only useful when use_data parameter is a taxonomic level, e.g., "Genus".}

\item{\code{other_taxa}}{default NULL; character vector containing a series of taxa names; used when use_data = "other"; 
the provided names should be standard full names used to select taxa from all the tables in taxa_abund list of the microtable object;
please see the example.}

\item{\code{group_use}}{default NULL; numeric or character vector to select one column in sample_table for selecting samples; together with group_select.}

\item{\code{group_select}}{default NULL; the group name used; remain samples within the group.}

\item{\code{taxa_name_full}}{default TRUE; Whether use the complete taxonomic name of taxa.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_cor in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t2 <- trans_diff$new(dataset = dataset, method = "rf", group = "Group", rf_taxa_level = "Genus")
t1 <- trans_env$new(dataset = dataset, add_data = env_data_16S[, 4:11])
t1$cal_cor(use_data = "other", p_adjust_method = "fdr", other_taxa = t2$res_diff$Taxa[1:40])
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_cor"></a>}}
\if{latex}{\out{\hypertarget{method-plot_cor}{}}}
\subsection{Method \code{plot_cor()}}{
Plot correlation heatmap.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$plot_cor(
  color_vector = c("#053061", "white", "#A50026"),
  color_palette = NULL,
  pheatmap = FALSE,
  filter_feature = NULL,
  ylab_type_italic = FALSE,
  keep_full_name = FALSE,
  keep_prefix = TRUE,
  text_y_order = NULL,
  text_x_order = NULL,
  font_family = NULL,
  cluster_ggplot = "none",
  cluster_height_rows = 0.2,
  cluster_height_cols = 0.2,
  text_y_position = "right",
  mylabels_x = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color_vector}}{default c("#053061", "white", "#A50026"); colors with only three values representing low, middle and high value.}

\item{\code{color_palette}}{default NULL; a customized palette with more color values; if provided, use it instead of color_vector.}

\item{\code{pheatmap}}{default FALSE; whether use pheatmap package to plot the heatmap.}

\item{\code{filter_feature}}{default NULL; character vector; used to filter features that only have significance labels in the filter_feature vector. 
For example, filter_feature = "" can be used to filter features that only have "", no any "*".}

\item{\code{ylab_type_italic}}{default FALSE; whether use italic type for y lab text.}

\item{\code{keep_full_name}}{default FALSE; whether use the complete taxonomic name.}

\item{\code{keep_prefix}}{default TRUE; whether retain the taxonomic prefix.}

\item{\code{text_y_order}}{default NULL; character vector; provide customized text order for y axis; shown in the plot from the top down.}

\item{\code{text_x_order}}{default NULL; character vector; provide customized text order for x axis.}

\item{\code{font_family}}{default NULL; font family used in ggplot2; only available when pheatmap = FALSE.}

\item{\code{cluster_ggplot}}{default "none"; add clustering dendrogram for ggplot2 based heatmap; 
available options: "none", "row", "col" or "both". "none": no any clustering used;
"row": add clustering for rows; "col": add clustering for columns; "both":  add clustering for both rows and columns.
Only available when pheatmap = FALSE.}

\item{\code{cluster_height_rows}}{default 0.2, the dendrogram plot height for rows; available when cluster_ggplot != "none".}

\item{\code{cluster_height_cols}}{default 0.2, the dendrogram plot height for columns; available cluster_ggplot != "none".}

\item{\code{text_y_position}}{default "right"; "left" or "right"; the y axis text position; ggplot2 based heatmap.}

\item{\code{mylabels_x}}{default NULL; provide x axis text labels additionally; only available when pheatmap = TRUE.}

\item{\code{...}}{paremeters pass to ggplot2::geom_tile or pheatmap, depending on the pheatmap = FALSE or TRUE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
plot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_cor(pheatmap = FALSE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_scatterfit"></a>}}
\if{latex}{\out{\hypertarget{method-plot_scatterfit}{}}}
\subsection{Method \code{plot_scatterfit()}}{
Scatter plot and add fitted line. The most important thing is to make sure that the input x and y
 have correponding sample orders. If one of x and y is a matrix, the other will be also transformed to matrix with Euclidean distance.
 Then, both of them are transformed to be vectors. If x or y is a vector with a single value, x or y will be
 assigned according to the column selection of the data_env inside.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$plot_scatterfit(
  x = NULL,
  y = NULL,
  group = NULL,
  group_order = NULL,
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  shape_values = NULL,
  type = c("cor", "lm")[1],
  cor_method = "pearson",
  label_sep = ";",
  label.x.npc = "left",
  label.y.npc = "top",
  label.x = NULL,
  label.y = NULL,
  x_axis_title = "",
  y_axis_title = "",
  point_size = 5,
  point_alpha = 0.6,
  line_size = 0.8,
  line_alpha = 1,
  line_color = "black",
  line_se = TRUE,
  line_se_color = "grey70",
  pvalue_trim = 4,
  cor_coef_trim = 3,
  lm_fir_trim = 2,
  lm_sec_trim = 2,
  lm_squ_trim = 2,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{default NULL; a single numeric or character value or a vector or a distance matrix used for the x axis.
If x is a single value, it will be used to select the column of data_env inside.
If x is a distance matrix, it will be transformed to be a vector.}

\item{\code{y}}{default NULL; a single numeric or character value or a vector or a distance matrix used for the y axis.
If y is a single value, it will be used to select the column of data_env inside.
If y is a distance matrix, it will be transformed to be a vector.}

\item{\code{group}}{default NULL; a character vector; if length is 1, must be a colname of dataset$sample_table;
Otherwise, group should be a vector with same length of x/y (for vector) or ncol of x/y (for matrix).}

\item{\code{group_order}}{default NULL; a vector to order groups, i.e. reorder the legend and colors in plot when group is not NULL; 
If group_order is NULL and group is provided, the function can first check whether the group column of dataset$sample_table is factor. 
If provided, overlook the levels in the group of dataset$sample_table.}

\item{\code{color_values}}{default RColorBrewer::brewer.pal(8, "Dark2"); color pallete for different groups.}

\item{\code{shape_values}}{default NULL; a numeric vector for point shape types of groups when group is not NULL, see ggplot2 tutorial.}

\item{\code{type}}{default c("cor", "lm")[1]; "cor": correlation; "lm" for regression.}

\item{\code{cor_method}}{default "pearson"; one of "pearson", "kendall" and "spearman"; correlation method.}

\item{\code{label_sep}}{default ";"; the separator string between different label parts.}

\item{\code{label.x.npc}}{default "left"; can be numeric or character vector of the same length as the number of groups and/or panels. If too short they will be recycled.
\describe{
  \item{numeric}{value should be between 0 and 1. Coordinates to be used for positioning the label, expressed in "normalized parent coordinates"}
  \item{character}{allowed values include: i) one of c('right', 'left', 'center', 'centre', 'middle') for x-axis; ii) and one of 
     c( 'bottom', 'top', 'center', 'centre', 'middle') for y-axis.}
}}

\item{\code{label.y.npc}}{default "top"; same usage with label.x.npc; see also label.y.npc parameter of stat_cor of ggpubr package.}

\item{\code{label.x}}{default NULL; x axis absolute position for adding the statictic label.}

\item{\code{label.y}}{default NULL; x axis absolute position for adding the statictic label.}

\item{\code{x_axis_title}}{default ""; the title of x axis.}

\item{\code{y_axis_title}}{default ""; the title of y axis.}

\item{\code{point_size}}{default 5; point size value.}

\item{\code{point_alpha}}{default 0.6; alpha value for the point color transparency.}

\item{\code{line_size}}{default 0.8; line size value.}

\item{\code{line_alpha}}{default 1; alpha value for the line color transparency.}

\item{\code{line_color}}{default "black"; fitted line color only useful when group = NULL.}

\item{\code{line_se}}{default TRUE; Whether show the confidence interval for the fitting.}

\item{\code{line_se_color}}{default "grey70"; the color to fill the confidence interval when line_se = TRUE.}

\item{\code{pvalue_trim}}{default 4; trim the decimal places of p value.}

\item{\code{cor_coef_trim}}{default 3; trim the decimal places of correlation coefficient.}

\item{\code{lm_fir_trim}}{default 2; trim the decimal places of regression first coefficient.}

\item{\code{lm_sec_trim}}{default 2; trim the decimal places of regression second coefficient.}

\item{\code{lm_squ_trim}}{default 2; trim the decimal places of regression R square.}

\item{\code{...}}{other arguments to pass to geom_text or geom_label.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
plot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_scatterfit(x = 1, y = 2, type = "cor")
t1$plot_scatterfit(x = 1, y = 2, type = "lm", point_alpha = .3)
t1$plot_scatterfit(x = "pH", y = "TOC", type = "lm", group = "Group", line_se = FALSE)
t1$plot_scatterfit(x = 
	 dataset$beta_diversity$bray[rownames(t1$data_env), rownames(t1$data_env)], y = "pH")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print the trans_env object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
