%% $Id: rarefaction.Rd 185 2014-09-03 08:09:01Z larssn $

\name{rarefaction}
\alias{rarefaction}

\title{
  Rarefaction curves for a pan-genome
}
\description{
  Computes rarefaction curves for a number of random permutations of genomes.
}
\usage{
rarefaction(pan.matrix,n.perm=1)
}
\arguments{
  \item{pan.matrix}{A \code{Panmat} object, see \code{\link{panMatrix}} for details.}
  \item{n.perm}{The number of random genome orderings to use. If \samp{n.perm=1} the fixed order of the genomes in \samp{pan.matrix} is used.}
}
\details{
  A rarefaction curve is simply the cumulative number of unique gene clusters we observe as more and more genomes are being considered. The shape of this curve will depend on the order of the genomes. This function will typically compute rarefaction curves for a number of (\samp{n.perm}) orderings. By using a large number of permutations, and then averaging over the results, the effect of any particular ordering is smoothed away.
  
  The averaged curve illustrates how many new gene clusters we observe for each new genome. If this levels out and becomes flat, it means we expect few, if any, new gene clusters by sequencing more genomes. The function \code{\link{heaps}} can be used to estimate population openness based on this principle.
}
\value{
  This function returns a \code{Rarefac} object, which is a small extension to a matrix. The generic functions \code{\link{plot.Rarefac}}, \code{\link{summary.Rarefac}} and \code{\link{str.Rarefac}} are available for such objects.
}
\author{
  Lars Snipen and Kristian Hovde Liland.
}
\seealso{
  \code{\link{heaps}}, \code{\link{panMatrix}}, \code{\link{plot.Rarefac}}, \code{\link{summary.Rarefac}}, \code{\link{str.Rarefac}}.
}
\examples{
# Loading two Panmat objects in the micropan package
data(list=c("Mpneumoniae.blast.panmat","Mpneumoniae.domain.panmat"),package="micropan")

# Rarefaction based on a BLAST clustering Panmat object
rarefac.blast <- rarefaction(Mpneumoniae.blast.panmat,n.perm=100)
plot(rarefac.blast)

# Rarefaction based on domain sequence clustering Panmat object
rarefac.domains <- rarefaction(Mpneumoniae.domain.panmat,n.perm=1000)
summary(rarefac.domains)
}
