% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnaManipulate.R
\name{translate}
\alias{translate}
\title{Translation according to the standard genetic code}
\usage{
translate(nuc.sequences, M.start = TRUE, no.stop = TRUE,
  trans.tab = 1)
}
\arguments{
\item{nuc.sequences}{Character vector containing the nucleotide sequences.}

\item{M.start}{A logical indicating if the amino acid sequence should start with M regardless of start codon (ATG, GTG or TTG).}

\item{no.stop}{A logical indicating if terminal stops (*) should be eliminated from the translated sequence}

\item{trans.tab}{Translation table, either 1 or 4}
}
\value{
A character vector of translated sequences.
}
\description{
The translation from DNA(RNA) to amino acid sequence according to the standard genetic code.
}
\details{
Translating DNA or RNA to protein. Possible start codons are ATG, GTG or TTG. Stop codons are TAA, TGA, TAG. All codons are
translated accoring to the Stadard geneti code. This is translation table 1. The only alternative implemented here is translation 
table 4, which is used by some bacteria (e.g. Mycoplasma, Mesoplasma). If \code{trans.tab} is 4, the stop codon TGA is 
translated to W (Tryptophan).
}
\examples{
ex.file <- file.path(file.path(path.package("microseq"),"extdata"),"small.fasta")
fdta <- readFasta(ex.file)
translate(fdta$Sequence)

}
\author{
Lars Snipen and Kristian Hovde Liland.
}
