% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{sargan}
\alias{sargan}
\alias{sargan.ivreg}
\alias{sargan.micsr}
\title{Sargan test for GMM models}
\usage{
sargan(object, ...)

\method{sargan}{ivreg}(object, ...)

\method{sargan}{micsr}(object, ...)
}
\arguments{
\item{object}{a model fitted by GMM}

\item{...}{further arguments}
}
\value{
an object of class \code{"htest"}.
}
\description{
When a IV model is over-identified, the set of all the empirical
moment conditions can't be exactly 0. The test of the validity of
the instruments is based on a quadratic form of the vector of the
empirical moments
}
\examples{
cigmales <- cigmales \%>\%
       mutate(age2 = age ^ 2, educ2 = educ ^ 2,
              age3 = age ^ 3, educ3 = educ ^ 3,
              educage = educ * age)
gmm_cig <- expreg(cigarettes ~ habit + price + restaurant + income + age + age2 +
                 educ + educ2 + famsize + race | . - habit + age3 + educ3 +
                 educage + lagprice + reslgth, data = cigmales,
                 twosteps = FALSE)
sargan(gmm_cig)
}
\keyword{htest}
