% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mid_conditional.R
\name{mid.conditional}
\alias{mid.conditional}
\alias{print.mid.conditional}
\title{Calculate ICE of MID Models}
\usage{
mid.conditional(
  object,
  variable,
  data = NULL,
  keep.effects = TRUE,
  n.samples = 100L,
  max.nrow = 100000L,
  type = c("response", "link")
)

\method{print}{mid.conditional}(x, digits = max(3L, getOption("digits") - 2L), ...)
}
\arguments{
\item{object}{a "mid" object.}

\item{variable}{a character string or expression specifying the variable for the ICE calculation.}

\item{data}{a data frame containing observations for which ICE values are calculated. If not passed, data is extracted from \code{parent.env()} based on the function call of the "mid" object.}

\item{keep.effects}{logical. If \code{TRUE}, the effects of component functions are stored in the output object.}

\item{n.samples}{integer. The number of sample points for the calculation.}

\item{max.nrow}{an integer specifying the maximum number of rows of the output data frames.}

\item{type}{the type of prediction required. The default is "response". "link" is possible if the MID model uses a link function.}

\item{x}{a "mid.conditional" object to be printed.}

\item{digits}{an integer specifying the minimum number of significant digits to be printed.}

\item{...}{additional parameters to be passed to \code{print.default()} to print the sample point vector.}
}
\value{
\code{mid.conditional()} returns an object of class "mid.conditional" with the following components:
\item{terms}{the character vector of relevant terms.}
\item{observed}{the data frame of the actual observations and the corresponding predictions.}
\item{conditional}{the data frame of the hypothetical observations and the corresponding predictions.}
\item{values}{the sample points of the variable.}
}
\description{
\code{mid.conditional()} creates an object to draw ICE curves of a MID model.
}
\details{
\code{mid.conditional()} obtains predictions for hypothetical observations from a MID model and returns a "mid.conditional" object.
The graphing functions \code{ggmid()} and \code{plot()} can be used to generate the ICE curve plots.
}
\examples{
data(airquality, package = "datasets")
mid <- interpret(Ozone ~ .^2, airquality, lambda = 1)
mc <- mid.conditional(mid, "Wind", airquality)
mc
}
