% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RecombinatorCrossoverUniform.R
\name{dict_recombinators_xounif}
\alias{dict_recombinators_xounif}
\alias{RecombinatorCrossoverUniform}
\title{Crossover Recombinator}
\usage{
RecombinatorCrossoverUniform(keep_complement = TRUE)
}
\arguments{
\item{keep_complement}{(\code{logical(1)})\cr
Whether the operation should keep both resulting individuals (\code{TRUE}), or only the first and discard
the complement (\code{FALSE}). Default \code{TRUE}.
The \verb{$keep_complement} field will reflect this value.}
}
\value{
an object of class \code{\link{Recombinator}}: \code{rec("cmpmaybe", rec("swap"))}.
}
\description{
Values between two individuals are exchanged with component-wise independent probability.

This is a pseudo-class: It does not create a single R6-object of a class;
instead, it creates the object \code{rec("cmpmaybe", rec("swap"), p = 0.5)},
making use of the \code{\link{RecombinatorCmpMaybe}} and \code{\link{RecombinatorSwap}} operators.
}
\section{Supported Operand Types}{


Supported \code{\link[paradox:Param]{Param}} classes are: \code{\link[paradox:ParamLgl]{ParamLgl}}, \code{\link[paradox:ParamInt]{ParamInt}}, \code{\link[paradox:ParamDbl]{ParamDbl}}, \code{\link[paradox:ParamFct]{ParamFct}}
}

\section{Dictionary}{

This \code{\link{Recombinator}} can be created with the short access form \code{\link[=rec]{rec()}}
(\code{\link[=recs]{recs()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_recombinators}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
rec("xounif")
recs("xounif")  # takes vector IDs, returns list of Recombinators

# long form:
dict_recombinators$get("xounif")
}\if{html}{\out{</div>}}
}

\examples{
set.seed(1)
rx = rec("xounif")

print(rx)

p = ps(x = p_int(-5, 5), y = p_dbl(-5, 5), z = p_dbl(-5, 5))
data = data.frame(x = 0:5, y = 0:5, z = 0:5)

rx$prime(p)
rx$operate(data)

rx$param_set$values$p = 0.3
rx$operate(data)
}
\seealso{
Other recombinators: 
\code{\link{OperatorCombination}},
\code{\link{RecombinatorPair}},
\code{\link{Recombinator}},
\code{\link{dict_recombinators_cmpmaybe}},
\code{\link{dict_recombinators_convex}},
\code{\link{dict_recombinators_cvxpair}},
\code{\link{dict_recombinators_maybe}},
\code{\link{dict_recombinators_null}},
\code{\link{dict_recombinators_proxy}},
\code{\link{dict_recombinators_sbx}},
\code{\link{dict_recombinators_sequential}},
\code{\link{dict_recombinators_swap}},
\code{\link{dict_recombinators_xonary}}
}
\concept{recombinators}
