% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionaries.R
\name{mut}
\alias{mut}
\alias{muts}
\alias{rec}
\alias{recs}
\alias{sel}
\alias{sels}
\alias{scl}
\alias{scls}
\alias{ftr}
\alias{ftrs}
\title{Short Access Forms for Operators}
\usage{
mut(.key, ...)

muts(.keys, ...)

rec(.key, ...)

recs(.key, ...)

sel(.key, ...)

sels(.key, ...)

scl(.key, ...)

scls(.key, ...)

ftr(.key, ...)

ftrs(.key, ...)
}
\arguments{
\item{.key}{(\code{character(1)})\cr
Key passed to the respective \link[mlr3misc:Dictionary]{dictionary} to retrieve the object.}

\item{...}{(any)\cr
Additional arguments.}

\item{.keys}{(\code{character()})\cr
Keys passed to the respective \link[mlr3misc:Dictionary]{dictionary} to retrieve multiple objects.}
}
\value{
\itemize{
\item \code{\link{Mutator}} for \code{mut()}
\item list of \code{\link{Mutator}} for \code{muts()}
\item \code{\link{Recombinator}} for \code{rec()}.
\item list of \code{\link{Recombinator}} for \code{recs()}.
\item \code{\link{Selector}} for \code{sel()}.
\item list of \code{\link{Selector}} for \code{sels()}.
\item \code{\link{Scalor}} for \code{scl()}.
\item list of \code{\link{Scalor}} for \code{scls()}.
}
}
\description{
These functions complement \link{dict_mutators}, \link{dict_recombinators}, \link{dict_selectors} with functions in the spirit
of \link[mlr3:mlr_sugar]{mlr3::mlr_sugar}.
}
\examples{
mut("gauss", sdev = 0.5)
rec("xounif")
sel("random")
scl("nondom")
}
\seealso{
Other dictionaries: 
\code{\link{dict_filtors}},
\code{\link{dict_mutators}},
\code{\link{dict_recombinators}},
\code{\link{dict_scalors}},
\code{\link{dict_selectors}}
}
\concept{dictionaries}
