% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_cohesion.R
\name{cohesion}
\alias{cohesion}
\alias{graph_density}
\alias{graph_components}
\alias{graph_cohesion}
\alias{graph_adhesion}
\alias{graph_diameter}
\alias{graph_length}
\title{Measures of network cohesion or connectedness}
\usage{
graph_density(object)

graph_components(object)

graph_cohesion(object)

graph_adhesion(object)

graph_diameter(object)

graph_length(object)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}
}
\description{
These functions return values or vectors relating to how connected a network is
and where the nodes or edges that would increase fragmentation are.
}
\section{Functions}{
\itemize{
\item \code{graph_density}: summarises the ratio of ties
to the number of possible ties.

\item \code{graph_components}: Returns number of (strong) components in the network.
To get the 'weak' components of a directed graph,
please use \code{to_undirected()} first.

\item \code{graph_cohesion}: Returns the minimum number of nodes to remove
from the network needed to increase the number of components.

\item \code{graph_adhesion}: Returns the minimum number of edges needed
to remove from the network to increase the number of components.

\item \code{graph_diameter}: Returns the maximum path length in the network.

\item \code{graph_length}: Returns the average path length in the network.
}}

\examples{
graph_density(mpn_elite_mex)
graph_density(mpn_elite_usa_advice)
graph_cohesion(ison_marvel_relationships)
graph_cohesion(to_main_component(ison_marvel_relationships))
graph_adhesion(ison_marvel_relationships)
graph_adhesion(to_main_component(ison_marvel_relationships))
graph_diameter(ison_marvel_relationships)
graph_diameter(to_main_component(ison_marvel_relationships))
graph_length(ison_marvel_relationships)
graph_length(to_main_component(ison_marvel_relationships))
}
\references{
White, Douglas R and Frank Harary. 2001.
"The Cohesiveness of Blocks In Social Networks: Node Connectivity and Conditional Density."
\emph{Sociological Methodology} 31(1): 305-59.
}
\seealso{
Other measures: 
\code{\link{centralisation}},
\code{\link{centrality}},
\code{\link{closure}},
\code{\link{diversity}},
\code{\link{features}},
\code{\link{holes}}
}
\concept{measures}
