% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.R
\name{coercion}
\alias{coercion}
\alias{as_edgelist}
\alias{as_matrix}
\alias{as_igraph}
\alias{as_tidygraph}
\alias{as_network}
\title{Coercion between migraph-compatible object classes}
\usage{
as_edgelist(object)

as_matrix(object)

as_igraph(object, twomode = FALSE)

as_tidygraph(object, twomode = FALSE)

as_network(object)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix, from base R
\item edgelist, a data frame from base R or tibble from tibble
\item igraph, from the igraph package
\item network, from the network package
\item tbl_graph, from the tidygraph package
}}

\item{twomode}{Logical option used to override the heuristics for
distinguishing incidence from adjacency matrices. By default FALSE.}
}
\value{
The currently implemented coercions or translations are:\tabular{lccccc}{
   to/from \tab edgelists \tab matrices \tab igraph \tab tidygraph \tab network \cr
   edgelists (data frames) \tab X \tab X \tab X \tab X \tab X \cr
   matrices \tab X \tab X \tab X \tab X \tab X \cr
   igraph \tab X \tab X \tab X \tab X \tab X \cr
   tidygraph \tab X \tab X \tab X \tab X \tab X \cr
   network \tab X \tab X \tab X \tab X \tab X \cr
}
}
\description{
The \code{as_} functions in \code{{migraph}} coerce objects
between several common classes of social network objects.
These include:
\itemize{
\item edgelists, as data frames or tibbles
\item adjacency and incidence matrices
\item \code{{igraph}} \code{graph} objects
\item \code{{tidygraph}} \code{tbl_graph} objects
\item \code{{network}} \code{network} objects
}

An effort is made for all of these coercion routines to be as lossless
as possible, though some object classes are better at retaining certain
kinds of information than others.
Note also that there are some reserved column names in one or more
object classes, which could otherwise lead to some unexpected results.
}
\details{
Edgelists are expected to be held in data.frame or tibble class objects.
The first two columns of such an object are expected to be the
senders and receivers of a tie, respectively, and are typically
named "from" and "to" (even in the case of an undirected network).
These columns can contain integers to identify nodes or character
strings/factors if the network is labelled.
If the sets of senders and receivers overlap, a one-mode network
is inferred. If the sets contain no overlap, a two-mode network
is inferred.
If a third, numeric column is present, a weighted network
will be created.

Matrices can be either adjacency (one-mode) or incidence (two-mode) matrices.
Incidence matrices are typically inferred from unequal dimensions,
but since in rare cases a matrix with equal dimensions may still
be an incidence matrix, an additional argument \code{twomode} can be
specified to override this heuristic.

This information is usually already embedded in \code{{igraph}},
\code{{tidygraph}}, and \code{{network}} objects.
}
\examples{
test <- data.frame(id1 = c("A","B","B","C","C"),
                   id2 = c("I","G","I","G","H"))
as_edgelist(test)
as_matrix(test)
as_igraph(test)
as_tidygraph(test)
as_network(test)
}
\seealso{
Other manipulation: 
\code{\link{add}},
\code{\link{is}()},
\code{\link{to}}
}
\concept{manipulation}
