#' mikropml: User-Friendly R Package for Robust Machine Learning Pipelines
#'
#' `mikropml` implements supervised machine learning pipelines using regression,
#' support vector machines, decision trees, random forest, or gradient-boosted trees.
#' The main functions are `preprocess_data()` to process your data prior to
#' running machine learning, and `run_ml()` to run machine learning.
#'
#' @section Authors:
#'
#' - Begüm D. Topçuoğlu ([ORCID](http://orcid.org/0000-0003-3140-537X))
#' - Zena Lapp ([ORCID](http://orcid.org/0000-0003-4674-2176))
#' - Kelly L. Sovacool ([ORCID](http://orcid.org/0000-0003-3283-829X))
#' - Evan Snitkin ([ORCID](http://orcid.org/0000-0001-8409-278X))
#' - Jenna Wiens ([ORCID](http://orcid.org/0000-0002-1057-7722))
#' - Patrick D. Schloss ([ORCID](http://orcid.org/0000-0002-6935-4275))
#'
#' @section See vignettes:
#'
#' - [Introduction](http://www.schlosslab.org/mikropml/articles/introduction.html)
#' - [Preprocessing data](http://www.schlosslab.org/mikropml/articles/preprocess.html)
#' - [Hyperparameter tuning](http://www.schlosslab.org/mikropml/articles/tuning.html)
#' - [Parallel processing](http://www.schlosslab.org/mikropml/articles/parallel.html)
#' - [The mikropml paper](http://www.schlosslab.org/mikropml/articles/paper.html)
#'
#' @docType package
#' @name mikropml
NULL
