% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_samples.R
\name{summarize_samples}
\alias{summarize_samples}
\alias{summarize_samples.default}
\alias{summarize_samples.mild_df}
\title{Summarize data across functions}
\usage{
\method{summarize_samples}{default}(data, group_cols, .fns = list(mean = mean), cor = FALSE, ...)

\method{summarize_samples}{mild_df}(data, ...)
}
\arguments{
\item{data}{A data.frame, 'mild_df' object, or similar of data to summarize.}

\item{group_cols}{A character vector of column(s) that describe groups to
summarize across.}

\item{.fns}{A list of functions (default \code{list(mean = mean)}).}

\item{cor}{A logical (default \code{FALSE}) for whether to include correlations
between all features in the summarization.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A tibble with summarized data.  There will be one row for each set
of distinct groups specified by \code{group_cols}. There will be one column for
each of the \code{group_cols}, plus \code{length(.fns)} columns for each of the
features in \code{data}, plus correlation columns if specified.
}
\description{
Summarize a numeric data frame based on specified grouping columns and a list
of functions.  This is useful in summarizing a \code{mild_df} object from the
sample level to the instance level.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Method for data.frame-like objects.

\item \code{mild_df}: Method for \code{mild_df} objects.
}}

\examples{
fns <- list(mean = mean, sd = sd)
summarize_samples(mtcars, group_cols = c("cyl", "gear"), .fns = fns)
summarize_samples(mtcars, group_cols = c("cyl", "gear"), .fns = fns, cor = TRUE)

}
\author{
Sean Kent
}
