% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mimi-internal.R
\name{armijo.lr}
\alias{armijo.lr}
\title{armijo.lr
Performs Armijo backtracking line search along a pre-specified search direction}
\usage{
armijo.lr(y0, theta, theta.tmp, alpha.mat = 0, w, z, lambda1, var.type,
  b = 0.5, thresh = 1e-05, nu = 0.1, zeta = 0.1, th = 0.1,
  step = 1)
}
\arguments{
\item{y0}{nxp observations matrix}

\item{theta}{nxp matrix direction of update for matrix of interactions}

\item{theta.tmp}{nxp matrix, current matrix of interactions}

\item{alpha.mat}{nxp matrix, matrix of main effects}

\item{w}{weights of the quadratic approximation}

\item{z}{matrix around which the quadratic approximation is done}

\item{lambda1}{positive number, regularization parameter for nuclear norm penalty}

\item{var.type}{vector of length p indicating column types for y (gaussian, binary, poisson)}

\item{b}{positive number in (0,1) factor by which the step size is reduced}

\item{thresh}{positive number, convergence criterion}

\item{nu}{positive number, backtracking line search parameter, default 0.01}

\item{zeta}{positive number, backtracking line search parameter, default 0.1}

\item{th}{positive number, backtracking line search parameter, default 0.1}

\item{step}{number in (0,1), initial backtracking line search step, default 1}
}
\value{
A list with the following elements
\item{theta}{(nb individuals) x (nb variables) matrix containing the individual effects}
\item{objective}{a vector containing the value of the objective function at every iteration}
\item{step}{the step size}
}
\description{
armijo.lr
Performs Armijo backtracking line search along a pre-specified search direction
}
