% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPackages.R
\name{checkVersions}
\alias{checkVersions}
\title{Check for previous versions of packages in a miniCRAN repository.}
\usage{
checkVersions(pkgs = NULL, path = NULL, type = "source", Rversion = R.version)
}
\arguments{
\item{pkgs}{Character vector of packages to be installed. If not provided,
checks all files for multiple package versions.}

\item{path}{The local path to the directory where the miniCRAN repo resides.}

\item{type}{character, indicating the type of package to download and
install. See \code{\link[=install.packages]{install.packages()}}.}

\item{Rversion}{Version of R (only used if \code{type} is not \code{source}.) Defaults to \link{R.version}, but this can be specified as any of the following formats:
\itemize{
\item a character string with the two digit R version, e.g. "3.1"
\item a list with components \code{major} and \code{minor}
\item the result of \code{\link[=getRversion]{getRversion()}}
\item the result of \link{R.version}
}}
}
\value{
Returns invisibly the file paths to packages with multiple versions
for removal.

list with an element for each \code{type}, consisting of a character
vector of download paths
}
\description{
Checks for previous versions, and returns the file paths for packages with
multiple versions. You can subsequently decide which version to keep.
}
\examples{
### `checkVersions` and `add.packages.miniCRAN` require an existing miniCRAN repo

# Specify list of packages to download
revolution <- c(CRAN = getOption("minicran.mran"))
revolution
pkgs <- c("foreach")
pkgTypes <- c("source", "win.binary")

pdb <- cranJuly2014

\dontrun{
  pdb <- pkgAvail(repos = revolution, type = "source")
}

pkgList <- pkgDep(pkgs, availPkgs = pdb, repos = revolution, type = "source", suggests = FALSE)
pkgList

\dontrun{
  # Create temporary folder for miniCRAN
  dir.create(pth <- file.path(tempdir(), "miniCRAN"))

  # Make repo for source and win.binary
  makeRepo(pkgList, path = pth, repos = revolution, type = pkgTypes)

  # Add other versions of a package (and assume these were added previously)
  oldVers <- data.frame(package = c("foreach", "codetools", "iterators"),
                        version = c("1.4.0", "0.2-7", "1.0.5"),
                        stringsAsFactors = FALSE)
  pkgs <- oldVers$package
  addOldPackage(pkgs, path = pth, vers = oldVers$version, repos = revolution, type = "source")
  # NOTE: older binary versions would need to be build from source

  # List package versions in the miniCRAN repo (produces warning about duplicates)
  pkgVersionsSrc <- checkVersions(pkgs, path = pth, type = "source")
  pkgVersionsBin <- checkVersions(pkgs, path = pth, type = "win.binary")

  # After inspecting package versions, remove old versions
  basename(pkgVersionsSrc) # "foreach_1.4.0.tar.gz"  "foreach_1.4.2.tar.gz"
  basename(pkgVersionsBin) # "foreach_1.4.0.zip"     "foreach_1.4.2.zip"
  file.remove(c(pkgVersionsSrc[1], pkgVersionsBin[1]))

  # Rebuild package index after adding/removing files
  updateRepoIndex(pth, type = pkgTypes, Rversion = R.version)

  pkgAvail(pth, type = "source")

  # Add new packages (from CRAN) to the miniCRAN repo
  addPackage("Matrix", path = pth, repos = revolution, type = pkgTypes)

  # Delete temporary folder
  unlink(pth, recursive = TRUE)
}
}
\seealso{
Other update repo functions: 
\code{\link{addOldPackage}()},
\code{\link{addPackage}()},
\code{\link{makeRepo}()},
\code{\link{updatePackages}()}
}
\concept{update repo functions}
