#' Example miniMeta analyses
#'
#' These are example miniMeta meta-analyses, with study data taken from
#' \href{https://www.ncbi.nlm.nih.gov/pubmed/24587664}{Lytras et al, 2014}.
#' Object \code{example_miniMeta_rct} contains a meta-analysis of Randomized 
#' Controlled Trials (RCTs), and \code{example_miniMeta_obs} a meta-analysis 
#' of observational studies.
#'
#' @name example_analyses
#' @aliases example_miniMeta_obs
#' @aliases example_miniMeta_rct
#'
#' @docType data
#'
#' @format Objects of class \code{miniMeta}
#'
#' @keywords datasets
#'
#' @references Lytras T, Nikolopoulos G, Bonovas S. World J Gastroenterol 
#' 2014;20(7):1858-70 (\href{https://www.ncbi.nlm.nih.gov/pubmed/24587664}{PubMed})
NULL

#' @rdname example_analyses
"example_miniMeta_obs" 

#' @rdname example_analyses
"example_miniMeta_rct"
