% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daemons.R
\name{daemons}
\alias{daemons}
\title{Daemons (Set Persistent Processes)}
\usage{
daemons(
  n,
  url = NULL,
  remote = NULL,
  dispatcher = TRUE,
  ...,
  seed = NULL,
  serial = NULL,
  tls = NULL,
  pass = NULL,
  .compute = NULL
)
}
\arguments{
\item{n}{integer number of daemons to launch.}

\item{url}{[default NULL] if specified, a character string comprising a URL
at which to listen for remote daemons, including a port accepting incoming
connections, e.g. 'tcp://hostname:5555' or 'tcp://10.75.32.70:5555'.
Specify a URL with scheme 'tls+tcp://' to use secure TLS connections (for
details see Distributed Computing section below). Auxiliary function
\code{\link[=host_url]{host_url()}} may be used to construct a valid host URL.}

\item{remote}{[default NULL] required only for launching remote daemons, a
configuration generated by \code{\link[=remote_config]{remote_config()}} or \code{\link[=ssh_config]{ssh_config()}}.}

\item{dispatcher}{[default TRUE] logical value, whether to use dispatcher.
Dispatcher runs in a separate process to ensure optimal scheduling,
and should normally be kept on (for details see Dispatcher section below).}

\item{...}{(optional) additional arguments passed through to
\code{\link[=daemon]{daemon()}} if launching daemons. These include \code{asyncdial}, \code{autoexit},
\code{cleanup}, \code{output}, \code{maxtasks}, \code{idletime} and \code{walltime}.}

\item{seed}{[default NULL] (optional) supply a random seed (single value,
interpreted as an integer). This is used to inititalise the L'Ecuyer-CMRG
RNG streams sent to each daemon. Note that reproducible results can be
expected only for \code{dispatcher = FALSE}, as the unpredictable timing of task
completions would otherwise influence the tasks sent to each daemon. Even
for \code{dispatcher = FALSE}, reproducibility is not guaranteed if the order in
which tasks are sent is not deterministic.}

\item{serial}{[default NULL] (optional, requires dispatcher) a
configuration created by \code{\link[=serial_config]{serial_config()}} to register serialization and
unserialization functions for normally non-exportable reference objects,
such as Arrow Tables or torch tensors. If \code{NULL}, configurations registered
with \code{\link[=register_serial]{register_serial()}} are automatically applied.}

\item{tls}{[default NULL] (optional for secure TLS connections) if not
supplied, zero-configuration single-use keys and certificates are
automatically generated. If supplied, \strong{either} the character path to
a file containing the PEM-encoded TLS certificate and associated private
key (may contain additional certificates leading to a validation chain,
with the TLS certificate first), \strong{or} a length 2 character vector
comprising [i] the TLS certificate (optionally certificate chain) and
[ii] the associated private key.}

\item{pass}{[default NULL] (required only if the private key supplied to
\code{tls} is encrypted with a password) For security, should be provided
through a function that returns this value, rather than directly.}

\item{.compute}{[default NULL] character value for the compute profile
to use (each has its own independent set of daemons), or NULL to use the
'default' profile.}
}
\value{
The integer number of daemons launched locally (zero if specifying
\code{url} or using a remote launcher).
}
\description{
Set daemons, or persistent background processes, to receive \code{\link[=mirai]{mirai()}}
requests. Specify \code{n} to create daemons on the local machine. Specify \code{url}
to receive connections from remote daemons (for distributed computing across
the network). Specify \code{remote} to optionally launch remote daemons via a
remote configuration. Dispatcher (enabled by default) ensures optimal
scheduling.
}
\details{
Use \code{daemons(0)} to reset daemon connections:
\itemize{
\item All connected daemons and/or dispatchers exit automatically.
\item \pkg{mirai} reverts to the default behaviour of creating a new
background process for each request.
\item Any unresolved 'mirai' will return an 'errorValue' 19 (Connection
reset) after a reset.
\item Daemons must be reset before calling \code{daemons()} with revised
settings for a compute profile. Daemons may be added at any time by using
\code{\link[=launch_local]{launch_local()}} or \code{\link[=launch_remote]{launch_remote()}} without needing to revise daemons
settings.
}

If the host session ends, all connected dispatcher and daemon processes
automatically exit as soon as their connections are dropped (unless the
daemons were started with \code{autoexit = FALSE}). If a daemon is processing
a task, it will exit as soon as the task is complete.

To reset persistent daemons started with \code{autoexit = FALSE}, use
\code{daemons(NULL)} instead, which also sends exit signals to all connected
daemons prior to resetting.

For historical reasons, \code{daemons()} with no arguments (other than
optionally \code{.compute}) returns the value of \code{\link[=status]{status()}}.
}
\section{Local Daemons}{


Daemons provide a potentially more efficient solution for asynchronous
operations as new processes no longer need to be created on an \emph{ad hoc}
basis.

Supply the argument \code{n} to set the number of daemons. New background
\code{\link[=daemon]{daemon()}} processes are automatically created on the local machine
connecting back to the host process, either directly or via dispatcher.
}

\section{Dispatcher}{


By default \code{dispatcher = TRUE} launches a background process running
\code{\link[=dispatcher]{dispatcher()}}. Dispatcher connects to daemons on behalf of the host, queues
tasks, and ensures optimal FIFO scheduling. Dispatcher also enables (i) mirai
cancellation using \code{\link[=stop_mirai]{stop_mirai()}} or when using a \code{.timeout} argument to
\code{\link[=mirai]{mirai()}}, and (ii) the use of custom serialization configurations.

Specifying \code{dispatcher = FALSE}, daemons connect directly to the host and
tasks are distributed in a round-robin fashion, with tasks queued at each
daemon. Optimal scheduling is not guaranteed as, depending on the duration of
tasks, they can be queued at one daemon while others remain idle. However,
this solution is the most resource-light, and suited to similar-length tasks,
or where concurrent tasks typically do not exceed available daemons.
}

\section{Distributed Computing}{


Specifying \code{url} as a character string allows tasks to be distributed across
the network. \code{n} is only required in this case if providing a launch
configuration to \code{remote} to launch remote daemons.

Supply a URL with a 'tcp://' scheme, such as 'tcp://10.75.32.70:5555'. The
host / dispatcher listens at this address, utilising a single port.
Individual daemons (started with \code{\link[=daemon]{daemon()}}) may then dial in to this URL.
Host / dispatcher automatically adjusts to the number of daemons actually
connected, allowing dynamic upscaling or downscaling as required.

Switching the URL scheme to 'tls+tcp://' automatically upgrades the
connection to use TLS. The auxiliary function \code{\link[=host_url]{host_url()}} may be used to
construct a valid host URL based on the computer's IP address.

IPv6 addresses are also supported and must be enclosed in square brackets
\verb{[]} to avoid confusion with the final colon separating the port. For
example, port 5555 on the IPv6 loopback address ::1 would be specified as
'tcp://[::1]:5555'.

Specifying the wildcard value zero for the port number e.g. 'tcp://[::1]:0'
will automatically assign a free ephemeral port. Use \code{\link[=status]{status()}} to inspect
the actual assigned port at any time.

Specify \code{remote} with a call to \code{\link[=remote_config]{remote_config()}} or \code{\link[=ssh_config]{ssh_config()}} to launch
daemons on remote machines. Otherwise, \code{\link[=launch_remote]{launch_remote()}} may be used to
generate the shell commands to deploy daemons manually on remote resources.
}

\section{Compute Profiles}{


If \code{NULL}, the \code{"default"} compute profile is used. Providing a character value
for \code{.compute} creates a new compute profile with the name specified. Each
compute profile retains its own daemons settings, and may be operated
independently of each other. Some usage examples follow:

\strong{local / remote} daemons may be set with a host URL and specifying
\code{.compute} as \code{"remote"}, which creates a new compute profile. Subsequent
\code{\link[=mirai]{mirai()}} calls may then be sent for local computation by not specifying the
\code{.compute} argument, or for remote computation to connected daemons by
specifying the \code{.compute} argument as \code{"remote"}.

\strong{cpu / gpu} some tasks may require access to different types of daemon,
such as those with GPUs. In this case, \code{daemons()} may be called to set up
host URLs for CPU-only daemons and for those with GPUs, specifying the
\code{.compute} argument as \code{"cpu"} and \code{"gpu"} respectively. By supplying the
\code{.compute} argument to subsequent \code{\link[=mirai]{mirai()}} calls, tasks may be sent to
either \code{cpu} or \code{gpu} daemons as appropriate.

Note: further actions such as resetting daemons via \code{daemons(0)} should
be carried out with the desired \code{.compute} argument specified.
}

\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# Create 2 local daemons (using dispatcher)
daemons(2)
status()
# Reset to zero
daemons(0)

# Create 2 local daemons (not using dispatcher)
daemons(2, dispatcher = FALSE)
status()
# Reset to zero
daemons(0)

# Set up dispatcher accepting TLS over TCP connections
daemons(url = host_url(tls = TRUE))
status()
# Reset to zero
daemons(0)

# Set host URL for remote daemons to dial into
daemons(url = host_url(), dispatcher = FALSE)
status()
# Reset to zero
daemons(0)

# Use with() to evaluate with daemons for the duration of the expression
with(
  daemons(2),
  {
    m1 <- mirai(Sys.getpid())
    m2 <- mirai(Sys.getpid())
    cat(m1[], m2[], "\n")
  }
)

\dontrun{

# Launch daemons on remotes 'nodeone' and 'nodetwo' using SSH
# connecting back directly to the host URL over a TLS connection:
daemons(
  url = host_url(tls = TRUE),
  remote = ssh_config(c('ssh://nodeone', 'ssh://nodetwo'))
)

# Launch 4 daemons on the remote machine 10.75.32.90 using SSH tunnelling:
daemons(
  n = 4,
  url = local_url(tcp = TRUE),
  remote = ssh_config('ssh://10.75.32.90', tunnel = TRUE)
)

}
\dontshow{\}) # examplesIf}
}
