% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/boot.mirt.R
\name{boot.mirt}
\alias{boot.mirt}
\title{Calculate bootstrapped standard errors for estimated models}
\usage{
boot.mirt(x, R = 100, technical = NULL, ...)
}
\arguments{
\item{x}{an estimated model object}

\item{R}{number of draws to use (passed to the \code{boot()} function)}

\item{technical}{technical arguments passed to estimation engine. See \code{\link{mirt}}
for details}

\item{...}{additional arguments to be passed on to \code{boot(...)} and estimation engine}
}
\description{
Given an internal mirt object estimate the bootstrapped standard errors. It may
be beneficial to run the computations using multi-core architecture (e.g., the \code{parallel}
package). Parameters are organized from the freely estimated values in \code{mod2values(x)}
(equality constraints will also be returned in the bootstrapped estimates).
}
\examples{
\dontrun{

#standard
mod <- mirt(Science, 1)
booted <- boot.mirt(mod, R=20)
plot(booted)
booted

#run in parallel using snow back-end using all available cores
mod <- mirt(Science, 1)
booted <- boot.mirt(mod, parallel = 'snow', ncpus = parallel::detectCores())
booted


}
}
\seealso{
\code{\link{PLCI.mirt}}
}
\keyword{bootstrapped}
\keyword{errors}
\keyword{standard}

