% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iteminfo.R
\name{iteminfo}
\alias{iteminfo}
\title{Function to calculate item information}
\usage{
iteminfo(x, Theta, degrees = NULL, total.info = TRUE,
  multidim_matrix = FALSE)
}
\arguments{
\item{x}{an extracted internal mirt object containing item information (see \code{\link{extract.item}})}

\item{Theta}{a vector (unidimensional) or matrix (multidimensional) of latent trait values}

\item{degrees}{a vector of angles in degrees that are between 0 and 90.
Only applicable when the input object is multidimensional}

\item{total.info}{logical; return the total information curve for the item? If \code{FALSE},
information curves for each category are returned as a matrix}

\item{multidim_matrix}{logical; compute the information matrix for each row in \code{Theta}? If \code{Theta}
contains more than 1 row then a list of matrices will be returned, otherwise if \code{Theta} has exactly
one row then a matrix will be returned}
}
\description{
Given an internal mirt item object extracted by using \code{\link{extract.item}},
compute the item information.
}
\examples{

mod <- mirt(Science, 1)
extr.2 <- extract.item(mod, 2)
Theta <- matrix(seq(-4,4, by = .1))
info.2 <- iteminfo(extr.2, Theta)

#do something with the info?
plot(Theta, info.2, type = 'l', main = 'Item information')

\dontrun{

#category information curves
cat.info <- iteminfo(extr.2, Theta, total.info = FALSE)
plot(Theta, cat.info[,1], type = 'l', ylim = c(0, max(cat.info)),
     ylab = 'info', main = 'Category information')
for(i in 2:ncol(cat.info))
   lines(Theta, cat.info[,i], col = i)

## Customized test information plot
T1 <- T2 <- 0
dat <- expand.table(LSAT7)
mod1 <- mirt(dat, 1)
mod2 <- mirt(dat, 1, 'Rasch')
for(i in 1:5){
  T1 <- T1 + iteminfo(extract.item(mod1, i), Theta)
  T2 <- T2 + iteminfo(extract.item(mod2, i), Theta)
}
plot(Theta, T2/T1, type = 'l', ylab = 'Relative Test Information', las = 1)
lines(Theta, T1/T1, col = 'red')

# multidimensional
mod <- mirt(dat, 2, TOL=1e-2)
ii <- extract.item(mod, 1)
Theta <- as.matrix(expand.grid(-4:4, -4:4))

iteminfo(ii, Theta, degrees=c(45,45)) # equal angle
iteminfo(ii, Theta, degrees=c(90,0)) # first dimension only

# information matrices
iteminfo(ii, Theta, multidim_matrix = TRUE)
iteminfo(ii, Theta[1, , drop=FALSE], multidim_matrix = TRUE)

}
}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.
\doi{10.18637/jss.v048.i06}
}
\seealso{
\code{\link{extract.item}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{information}
