% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createShinyGUI.R
\name{createShinyGUI}
\alias{createShinyGUI}
\title{Function returning an object used by shiny}
\usage{
createShinyGUI(ui = NULL, host_server = TRUE)
}
\arguments{
\item{ui}{a shiny UI function used to define the interface. If \code{NULL}, the default one will be used. 
See \code{mirtCAT:::default_UI} for the internal code}

\item{host_server}{logical; is \code{createShinyGUI()} being used on a remote server or executed locally?
When \code{TRUE} any calls to \code{\link{stopApp}} are suppressed to allow for multiple sessions to
be executed. Note that \code{FALSE} gives the same behaviour as the GUI in \code{\link{mirtCAT}}}
}
\description{
This function returns the GUI setup results by calling \code{\link{shinyApp}}. 
Primarily, this is only useful when hosting the application publicly, such as 
through \url{http://www.shinyapps.io/}. The function \code{\link{mirtCAT_preamble}} must be 
run \emph{before} this function is called. The object is executed by calling \code{\link{runApp}}.
}
\examples{
\dontrun{

mirtCAT_preamble(df=df)
runApp(createShinyGUI(host_server = FALSE), port = 8000) # run locally

person <- getPerson()
summary(person)

runApp(createShinyGUI(), port = 8000) # for remote server hosting

} 
}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.
\doi{10.18637/jss.v048.i06}

Chalmers, R. P. (2016). Generating Adaptive and Non-Adaptive Test Interfaces for 
Multidimensional Item Response Theory Applications. \emph{Journal of Statistical Software, 71}(5), 
1-39. \doi{10.18637/jss.v071.i05}
}
\seealso{
\code{\link{mirtCAT}}, \code{\link{mirtCAT_preamble}}, \code{\link{getPerson}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
