% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqci.R
\name{qqci}
\alias{qqci}
\title{qqci function}
\usage{
qqci(
  x,
  rfun = NULL,
  y = NULL,
  ns = 100,
  zero = FALSE,
  standardise = FALSE,
  qts = c(0.025, 0.975),
  llwd = 2,
  lcol = "red",
  xlab = "Theoretical",
  ylab = "Sample",
  alpha = 0.02,
  cicol = "black",
  cilwd = 1,
  ...
)
}
\arguments{
\item{x}{a vector of values to compare}

\item{rfun}{a function accepting a single argument to generate samples from the comparison distribution, the default is rnorm}

\item{y}{an optional vector of samples to compare the quantiles against. In the case this is non-null, the function rfun will be automatically chosen as bootstrapping y with replacement and sample zise the same as the length of x. You must specify exactly one of rfun or y.}

\item{ns}{the number of simulations to generate: the more simulations, the more accurate the confidence bands. Default is 100}

\item{zero}{logical, whether to zero the plot across the x-axis. Default is FALSE}

\item{standardise}{logical, whether to standardise so that the variance around each quantile is made constant (this can help in situations where the confidence bands appear very tight in places)}

\item{qts}{vector of probabilities giving which sample-based empirical quantiles to add to the plot. Default is c(0.025,0.975)}

\item{llwd}{positive numeric, the width of line to plot, default is 2}

\item{lcol}{colour of line to plot, default is red}

\item{xlab}{character, the label for the x-axis}

\item{ylab}{character, the label for the y-axis}

\item{alpha}{controls transparency of samples (coloured blue)}

\item{cicol}{colour of confidence band lines, default is black}

\item{cilwd}{width of confidence band lines, default is 1}

\item{...}{additional arguments to pass to matplot}
}
\value{
Produces a QQ-plot with simulation-based confidence bands
}
\description{
A function to compare quantiles of a given vector against quantiles of a specified distribution. The function outputs
simulation-based confidence intervals too. The option of zero-ing the plot (rather than visualising a diagonal line (which
can be difficult to interpret) and also standardising (so that varying uncertainty around each quantile appears equal to the eye)
are also given.
}
\examples{
qqci(rnorm(1000))
qqci(rnorm(1000),zero=TRUE)
qqci(rnorm(1000),zero=TRUE,standardise=TRUE)
}
