% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals.R
\name{gintervals.intersect}
\alias{gintervals.intersect}
\title{Calculates an intersection of two sets of intervals}
\usage{
gintervals.intersect(
  intervals1 = NULL,
  intervals2 = NULL,
  intervals.set.out = NULL
)
}
\arguments{
\item{intervals1, intervals2}{set of intervals}

\item{intervals.set.out}{intervals set name where the function result is
optionally outputted}
}
\value{
If 'intervals.set.out' is 'NULL' a data frame representing the
intersection of intervals.
}
\description{
Calculates an intersection of two sets of intervals.
}
\details{
This function returns intervals that represent a genomic space which is
achieved by intersection of 'intervals1' and 'intervals2'.

If 'intervals.set.out' is not 'NULL' the result is saved as an intervals
set. Use this parameter if the result size exceeds the limits of the
physical memory.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()

intervs1 <- gscreen("dense_track > 0.15")
intervs2 <- gscreen("dense_track < 0.2")

## 'intervs3' and 'intervs4' are identical
intervs3 <- gintervals.intersect(intervs1, intervs2)
intervs4 <- gscreen("dense_track > 0.15 & dense_track < 0.2")

}
\seealso{
\code{\link{gintervals.2d.band_intersect}},
\code{\link{gintervals.diff}}, \code{\link{gintervals.union}},
\code{\link{gintervals}}, \code{\link{gintervals.2d}}
}
\keyword{~intersect}
