% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_kl_divergence.R
\name{multi_kl_divergence}
\alias{multi_kl_divergence}
\title{Multi-dataset Kullback-Leibler Divergence Calculation}
\usage{
multi_kl_divergence(datasets, minFreq = 1e-10)
}
\arguments{
\item{datasets}{List of dataframes, each containing allele frequencies for different populations.}

\item{minFreq}{Minimum frequency to be considered for unobserved or poorly observed alleles.}
}
\value{
A matrix containing the Kullback-Leibler divergence for each dataset pair.
}
\description{
This function calculates the Kullback-Leibler divergence for all pairs of provided datasets,
considering allele frequencies. It normalizes data, adjusts zero frequencies,
and computes KL divergence in both directions for each pair.
}
\examples{
kl_matrix <- multi_kl_divergence(list(Argentina, BosniaHerz, Europe))
}
