#' Adjusting Stochastic Block Models under various missing data conditions
#'
#' The missSBM package provides five functions:
#' \itemize{
#'   \item{\code{\link{simulate}}}{a function to define and draw network data according to a stochastic block model}
#'   \item{\code{\link{sample}}}{a function to sample an existing network according to a variety of sampling designs}
#'   \item{\code{\link{estimate}}}{a function to perform inference of SBM from network data with missing entries under various sampling designs.}
#'   \item{\code{prepare_data}}{a function to format real-world network data (adjacency matrix and covariates) to perform the estimation under missing data condition}
#'   \item{\code{\link{smooth}}}{a function to smooth an existing collection of SBM estimation, to avoid being trapped in local maxima.}
#' }
#'
#' These function leads to the manipulation of a variety of R object, with their respective fields and methods. They are all automatically generated by the top-level functions itemized above, so that the user should generally to use their constructor or internal methods directly. The user should only have a basic understanding of the fields of each object to manipulate the output in R. The main objects are the following:
#' \itemize{
#' \item{\code{\link{sampledNetwork}}}{an object to store sampled network data (i.e. with missing dyads)}
#' \item{\code{\link{SBM_sampler}}}{an object to define a SBM to sample from}
#' \item{\code{\link{SBM_fit}}}{an object to define and store an SBM fit }
#' \item{\code{\link{networkSampler}}}{an object to define a network sampling to sample from}
#' \item{\code{\link{networkSampling}}}{an object to define and store a network sampling fit}
#' \item{\code{\link{missSBM_fit}}}{an object that put together an SBM fit and and network sampling fit - the main point of the missSBM package !}
#' \item{\code{\link{missSBM_collection}}}{an object to store a collection of missSBM_fit, ordered by number of block}
#' }
#'
#' @docType package
#' @author Timothée Tabouy, Pierre Barbillon, Julien Chiquet
#' @references Timothée Tabouy, Pierre Barbillon & Julien Chiquet (2019) “Variational Inference for Stochastic Block Models from Sampled Data”, Journal of the American Statistical Association, <doi:10.1080/01621459.2018.1562934>
#' @import R6 methods igraph
#' @useDynLib missSBM
#' @importFrom Rcpp sourceCpp
#' @name missSBM
NULL
