% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.missSOM}
\alias{summary.missSOM}
\alias{print.missSOM}
\title{Summary and print methods for missSOM objects}
\usage{
\method{summary}{missSOM}(object, \dots)
\method{print}{missSOM}(x, \dots)

\method{print}{missSOM}(x, ...)
}
\arguments{
\item{object}{a \code{missSOM} object}

\item{...}{Not used.}

\item{x}{a \code{kohonen} object}
}
\value{
No return a value.
}
\description{
Summary and print methods for \code{missSOM} objects. The \code{print} 
method shows the dimensions and the topology of the map; if information on the training data is included, the \code{summary} 
method additionally prints information on the size of the data, the distance functions used, and the mean distance of an 
object to its closest codebookvector, which is an indication of the quality of the mapping.
}
\examples{
data(wines)
som.wines <- imputeSOM(scale(wines), grid = somgrid(5, 5, "hexagonal"))
som.wines
summary(som.wines)

}
\seealso{
\code{\link{imputeSOM}}
}
