% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{Distribution_summary}
\alias{Distribution_summary}
\alias{summary.standist}
\alias{summary.trans_standist}
\alias{summary.mixdist}
\alias{summary.trans_mixdist}
\alias{summary.compdist}
\alias{summary.trans_compdist}
\title{Displays a Useful Description of a Distribution Object}
\usage{
\method{summary}{standist}(object, level = 1, space = 2, additional_list, truncation, ...)

\method{summary}{trans_standist}(object, level = 1, space = 2, additional_list, truncation, ...)

\method{summary}{mixdist}(object, level = 1, space = 2, additional_list, truncation, ...)

\method{summary}{trans_mixdist}(object, level = 1, space = 2, additional_list, truncation, ...)

\method{summary}{compdist}(object, level = 1, space = 2, additional_list, truncation, ...)

\method{summary}{trans_compdist}(object, level = 1, space = 2, additional_list, truncation, ...)
}
\arguments{
\item{object}{distribution object to summarize.}

\item{level}{adds 3*(level-1) spaces before the print, default: 1.}

\item{space}{number of blank lines between outputs, default: 2.}

\item{additional_list, truncation, ...}{additional information that may be passed to summary.}
}
\description{
Displays a useful description of a distribution object from \code{\link{mistr}}.
}
\details{
\code{summary} prints useful description of a distribution object. This feature might
         be useful when working with a more complicated distribution that contains
         mixture and composite distributions as components and the print function does not
         offer enough information.

         Arguments \code{level}, \code{additional_list} and truncation
         are present for recursive usage that is done for more complicated models
         automatically by the function.
}
