% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skewness.R
\name{skewness}
\alias{skewness}
\title{Skewness}
\usage{
skewness(x, as.na = NULL, check = TRUE)
}
\arguments{
\item{x}{a numeric vector.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting the analysis.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\value{
Returns the estimated skewness of \code{x}.
}
\description{
This function computes the skewness.
}
\details{
The same method for estimating skewness is used in SAS and SPSS. Missing values (\code{NA})
are stripped before the computation. Note that at least 3 observations are needed to compute
skewness.
}
\examples{
# Set seed of the random number generation
set.seed(123)
# Generate random numbers according to N(0, 1)
x <- rnorm(100)

# Compute skewness
skewness(x)
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
New York: John Wiley & Sons.
}
\seealso{
\code{\link{kurtosis}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
