% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cti.R
\name{MapTactics}
\alias{MapTactics}
\title{Extract Tactic properties from x-mitre-tactic object (parsed with RJSONIO::fromJSON)}
\usage{
MapTactics(x.mitre.tactic = NA, domain = NA)
}
\arguments{
\item{x.mitre.tactic}{list based on STIX}

\item{domain}{must be "pre-attack", "enterprise-attack" or "mobile-attack"}
}
\value{
data.frame compliant with CTI USAGE document
}
\description{
Extract Tactic properties from x-mitre-tactic object (parsed with RJSONIO::fromJSON)
}
\examples{
\dontrun{
sf <- "https://github.com/mitre/cti/raw/master/<domain>/<object>/<file>.json"
x.mitre.tactic <- RJSONIO::fromJSON(sf)
df.ent.tact <- MapTactics(x.mitre.tactic, "enerprise-attack")
}
}
