% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenotypeFreq.R
\name{GenotypeFreq}
\alias{GenotypeFreq}
\title{Calculate Genotype Frequency###}
\usage{
GenotypeFreq(x,p,expect=TRUE)
}
\arguments{
\item{x}{a dataset of alleles. Each row denotes each sample. One allele in one cell.In the (2r-1)th column, there is the other allele on the same locus from that in the 2r-th column; noted: no column for ID, make row.names=1 when importing.}

\item{p}{a matrix of allele frequencies. Each row denotes each allele; each column denotes each marker. The order of markers follows x.}

\item{expect}{a logic variable. If expect is true, the function will calculate the expected genotype probabilities. If false, calculate the observed genotype frequencies.}
}
\value{
y a matrix of genotype frequencies. Each row denotes each genotype; each column denotes each loci. The order of markers follows x; the genotypes are ordered by: from 1:l-th column, the genotypes are homozygous in order as : p1p1, p2p2,p3p3,...,plpl;from ll-th to u-th column, the genotypes are heterozygous in order as:choose(l,2) like: p1p2,p1p3,...,p1pl,p2p3,p2p4,...p2pl,...p(l-1)pl
}
\description{
Calculate Genotype Frequency###
}
\details{
This function calculates the observed or expected genotype frequency from dataset and allele frequency.#####
}
\examples{
require(mixIndependR)
x <- data.frame(STR1=c(12,13,13,14,15,13,14,12,14,15),
               STR1_1=c(12,14,13,15,13,14,13,12,14,15),
               SNP1=c("A","T","A","A","T","A","A","T","T","A"),
               SNP1_1=c("A","T","T","T","A","T","A","A","T","T"))
p <- AlleleFreq(x)
GenotypeFreq(x,p,expect=TRUE)



}
\references{
Chakraborty, R., Srinivasan, M. R., & Daiger, S. P. (1993, ISSN:0002-9297).
}
