% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_clean.R
\name{data_clean}
\alias{data_clean}
\title{Data cleaning}
\usage{
data_clean(rawdata, levels.tol = 0.2)
}
\arguments{
\item{rawdata}{A data frame.}

\item{levels.tol}{Tolerant proportion of the number of levels to the number of observations in a multiclass variable. Default: 0.2}
}
\value{
A preliminary cleaned dataset
}
\description{
Check some common errors of a raw dataset and return a suitable dataset to be fed into the imputer. Note that this function is just a preliminary check. It will not guarantee the output dataset is fully cleaned.
}
\examples{
rawdata <- nhanes3

rawdata[4, 4] <- NaN
rawdata[5, 5] <- Inf
rawdata[6, 6] <- -Inf

cleandata <- data_clean(rawdata = rawdata)
}
