% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_line_search_function.R
\name{index_line_search}
\alias{index_line_search}
\title{Line search over indexed array in one direction}
\usage{
index_line_search(f, xarray, y1 = NULL, plot = "none", verbose = 0)
}
\arguments{
\item{f}{f}

\item{xarray}{xarray}

\item{y1}{y1}

\item{plot}{plot}

\item{verbose}{Level to print}
}
\value{
List
}
\description{
Line search over indexed array in one direction
}
\examples{
index_line_search(function(x) {(x-100)^2}, 1:290)
index_line_search(function(x) {(-x-100)^2}, -(1:290)^.92, plot="ind")
index_line_search(function(x) {(-x-100)^2}, -(1:290)^.92, plot="x")
xx <- sort(runif(1e2, -250, -30))
index_line_search(function(x) {(-x-100)^2}, xx, plot="ind")
index_line_search(function(x) {(-x-100)^2}, xx, plot="x")
}
