% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctx_tree.R
\name{ctx_tree}
\alias{ctx_tree}
\title{Build a context tree for a discrete time series}
\usage{
ctx_tree(x, min_size = 2, max_depth = 10, keep_position = FALSE)
}
\arguments{
\item{x}{a discrete time series; can be numeric, character or factor.}

\item{min_size}{integer >= 1 (default: 2). Minimum number of observations for
a context to be included in the tree.}

\item{max_depth}{integer >= 1 (default: 100). Maximum length of a context to
be included in the tree.}

\item{keep_position}{logical (default: TRUE). Should the context tree keep
the position of the contexts.}
}
\value{
a context tree (of class \code{ctx_tree}).
}
\description{
This function builds a context tree for a time series.
}
\details{
The tree represents all the sequences of symbols/states of length smaller
than \code{max_depth} that appear at least \code{min_size} times in the time series and
stores the frequencies of the states that follow each context. Optionally,
the positions of the contexts in the time series can be stored in the tree.
}
\examples{
dts <- c(0, 1, 1, 1, 0, 0, 1, 0, 1, 0)
## get all contexts of length 2
dts_ctree <- ctx_tree(dts, min_size = 1, max_depth = 2)
draw(dts_ctree)
}
