% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covlmc_simulate.R
\name{simulate.covlmc}
\alias{simulate.covlmc}
\title{Simulate a discrete time series for a covlmc}
\usage{
\method{simulate}{covlmc}(object, nsim = 1, seed = NULL, covariate, init = NULL, ...)
}
\arguments{
\item{object}{a fitted covlmc object.}

\item{nsim}{length of the simulated time series (defaults to 1).}

\item{seed}{an optional random seed.}

\item{covariate}{values of the covariates}

\item{init}{an optional initial sequence for the time series}

\item{...}{additional arguments.}
}
\value{
a simulated discrete time series of the same type as the one used to build the covlmc.
}
\description{
This function simulates a time series from the distribution estimated by the
given covlmc object.
}
\details{
A VLMC with covariates model needs covariates to compute its transition
probabilities. The covariates must be submitted as a data frame using the
\code{covariate} argument. In addition,  the time series can be initiated by a
fixed sequence specified via the \code{init} parameter.
}
\examples{
pc <- powerconsumption[powerconsumption$week == 5, ]
dts <- cut(pc$active_power, breaks = c(0, quantile(pc$active_power, probs = c(0.5, 1))))
dts_cov <- data.frame(day_night = (pc$hour >= 7 & pc$hour <= 17))
m_cov <- covlmc(dts, dts_cov, min_size = 5)
# new week with day light from 6:00 to 18:00
new_cov <- data.frame(day_night = rep(c(rep(FALSE, 59), rep(TRUE, 121), rep(FALSE, 60)), times = 7))
new_dts <- simulate(m_cov, nrow(new_cov), seed = 0, covariate = new_cov)
new_dts_2 <- simulate(m_cov, nrow(new_cov), seed = 0, covariate = new_cov, init = dts[1:10])
}
