% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctx_node_covlmc.R
\name{model}
\alias{model}
\title{Logistic model of a COVLMC context}
\usage{
model(node, type = c("coef", "full"))
}
\arguments{
\item{node}{A \code{ctx_node_covlmc} object as returned by \code{\link[=find_sequence]{find_sequence()}} or
\code{\link[=contexts.covlmc]{contexts.covlmc()}}}

\item{type}{specifies the model information to return, either the
coefficients only (\code{type="coef"} default case) or the full model object
(\code{type="full"})}
}
\value{
if \code{node} is a context, the coefficients of the logistic model (as a
vector or a matrix depending on the size of the state space) or a logistic
model as a R object. If \code{node} is not a context, \code{NULL}.
}
\description{
This function returns a representation of the logistic model associated to a
COVLMC context from its node in the associated context tree.
}
\details{
Full model extraction is only possible if the COVLMC model what not fully
trimmed (see \code{\link[=trim.covlmc]{trim.covlmc()}}). Notice that \code{\link[=find_sequence.covlmc]{find_sequence.covlmc()}} can
produce node that are not context: in this case this function return \code{NULL}.
}
\examples{
pc <- powerconsumption[powerconsumption$week == 5, ]
dts <- cut(pc$active_power, breaks = c(0, quantile(pc$active_power, probs = c(0.5, 1))))
dts_cov <- data.frame(day_night = (pc$hour >= 7 & pc$hour <= 17))
m_cov <- covlmc(dts, dts_cov, min_size = 10)
vals <- states(m_cov)
node <- find_sequence(m_cov, c(vals[1], vals[1]))
node
model(node)
model(node, type = "full")

}
