% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctx_node_covlmc.R
\name{is_merged}
\alias{is_merged}
\title{Merging status of a COVLMC context}
\usage{
is_merged(node)
}
\arguments{
\item{node}{A \code{ctx_node_covlmc} object as returned by \code{\link[=find_sequence]{find_sequence()}} or
\code{\link[=contexts.covlmc]{contexts.covlmc()}}}
}
\value{
TRUE or FALSE, depending on the nature of the context
}
\description{
The function returns \code{TRUE} if the context represented by this node is merged
with at least another one and \code{FALSE} if this is not the case.
}
\details{
When a COVLMC is built on a time series with at least three distinct states,
some contexts can be merged: they use the same logistic model, leading to a
more parsimonious model. Those contexts are reported individually by
functions such as \code{\link[=contexts.covlmc]{contexts.covlmc()}}. The present function can be used
to detect such merging, while \code{\link[=merged_with]{merged_with()}} can be used to recover the
other contexts.
}
\examples{
pc <- powerconsumption[powerconsumption$week == 15, ]
dts <- cut(pc$active_power, breaks = c(0, 1, 2, 3, 8))
dts_cov <- data.frame(day_night = (pc$hour >= 7 & pc$hour <= 17))
m_cov <- covlmc(dts, dts_cov, min_size = 5, alpha = 0.1)
ctxs <- contexts(m_cov)
## no merging
sapply(ctxs, is_merged)
}
\seealso{
\code{\link[=merged_with]{merged_with()}}
}
