% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_functions.R
\docType{methods}
\name{addSpecies}
\alias{addSpecies}
\alias{addSpecies,MizerParams-method}
\title{Add more species into an ecosystem with background species.}
\usage{
addSpecies(params, ...)

\S4method{addSpecies}{MizerParams}(params, species_params, SSB = NA,
  rfac = 10, effort = 0)
}
\arguments{
\item{params}{A mizer params object for the original system.}

\item{...}{Other arguments (unused)}

\item{species_params}{The species parameters of the new species we
want to add to the system.}

\item{SSB}{The spawning stock biomass of the new species. If not provided, 
the abundance of the new species will be chosen so that its maximal 
biomass density lies at half the community power law.}

\item{rfac}{A number that determines the strength of the non-linearity in
the Beverton-Holt stock-recruitment relationship. The maximal recruitment
will be set to rfac times the normal steady-state recruitment.
Default value is 10.}

\item{effort}{Default value is 0.}
}
\value{
An object of type \linkS4class{MizerParams}
}
\description{
Takes a \linkS4class{MizerParams} object and adds an additional species with
given parameters to the ecosystem.
}
\examples{
\dontrun{
params <- set_scaling_model(max_w_inf = 5000)
params <- setBackground(params)
a_m <- 0.0085
b_m <- 3.11
L_inf_m <- 24.3
L_mat <- 11.1
species_params <- data.frame(
    species = "mullet",
    w_min = 0.001, 
    w_inf = a_m*L_inf_m^b_m, 
    w_mat = a_m*L_mat^b_m, 
    beta = 283, 
    sigma = 1.8, 
    z0 = 0,
    alpha = 0.6,
    sel_func = "knife_edge", 
    knife_edge_size = 100, 
    gear = "knife_edge_gear",
    k = 0,
    k_vb = 0.6,
    a = a_m,
    b = b_m
)
params <- addSpecies(params, species_params)
plotSpectra(params)
sim <- project(params, t_max=50)
plotBiomass(sim)
}
}
