% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\docType{methods}
\name{getBiomassFrame}
\alias{getBiomassFrame}
\alias{getBiomassFrame,MizerSim-method}
\title{Get data frame of biomass of species through time, ready for ggplot2}
\usage{
getBiomassFrame(sim, ...)

\S4method{getBiomassFrame}{MizerSim}(sim,
  species = sim@params@species_params$species[!is.na(sim@params@A)],
  start_time = as.numeric(dimnames(sim@n)[[1]][1]),
  end_time = as.numeric(dimnames(sim@n)[[1]][dim(sim@n)[1]]), ylim = c(NA,
  NA), total = FALSE, ...)
}
\arguments{
\item{sim}{An object of class \linkS4class{MizerSim}}

\item{...}{Other arguments to pass to \code{getBiomass} method, for example
\code{min_w} and \code{max_w}}

\item{species}{Name or vector of names of the species to be plotted. By
default all species are plotted.}

\item{start_time}{The first time to be plotted. Default is the beginning
of the time series.}

\item{end_time}{The last time to be plotted. Default is the end of the
time series.}

\item{ylim}{A numeric vector of length two providing limits of for the
y axis. Use NA to refer to the existing minimum or maximum. Any values
below 1e-20 are always cut off.}

\item{total}{A boolean value that determines whether the total biomass from
all species is plotted as well. Default is FALSE}
}
\value{
A data frame that can be used in \code{\link{display_frames}}
}
\description{
After running a projection, the biomass of each species can be plotted
against time. The biomass is calculated within user defined size limits 
(min_w, max_w, min_l, max_l, see \code{\link{getBiomass}}).

Get the biomass frame from a \code{MizerSim} object.
}
\seealso{
\code{\link{getBiomass}}
}
