% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{getBiomassFrame}
\alias{getBiomassFrame}
\title{Get data frame of biomass of species through time, ready for ggplot2}
\usage{
getBiomassFrame(
  sim,
  species = dimnames(sim@n)$sp[!is.na(sim@params@A)],
  start_time = as.numeric(dimnames(sim@n)[[1]][1]),
  end_time = as.numeric(dimnames(sim@n)[[1]][dim(sim@n)[1]]),
  ylim = c(NA, NA),
  total = FALSE,
  ...
)
}
\arguments{
\item{sim}{An object of class \linkS4class{MizerSim}}

\item{species}{Name or vector of names of the species to be plotted. By
default all species are plotted.}

\item{start_time}{The first time to be plotted. Default is the beginning
of the time series.}

\item{end_time}{The last time to be plotted. Default is the end of the
time series.}

\item{ylim}{A numeric vector of length two providing lower and upper limits
for the y axis. Use NA to refer to the existing minimum or maximum. Any
values below 1e-20 are always cut off.}

\item{total}{A boolean value that determines whether the total biomass from
all species is plotted as well. Default is FALSE.}

\item{...}{
  Arguments passed on to \code{\link[=get_size_range_array]{get_size_range_array}}
  \describe{
    \item{\code{min_w}}{Smallest weight in size range. Defaults to smallest weight in
the model.}
    \item{\code{max_w}}{Largest weight in size range. Defaults to largest weight in the
model.}
    \item{\code{min_l}}{Smallest length in size range. If supplied, this takes
precedence over \code{min_w}.}
    \item{\code{max_l}}{Largest length in size range. If supplied, this takes precedence
over \code{max_w}.}
  }}
}
\value{
A data frame
}
\description{
After running a projection, the biomass of each species can be plotted
against time. The biomass is calculated within user defined size limits
(min_w, max_w, min_l, max_l, see \code{\link[=getBiomass]{getBiomass()}}).
}
\concept{frame functions}
