% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_functions.R
\name{getERepro}
\alias{getERepro}
\title{Get energy rate available for reproduction}
\usage{
getERepro(
  params,
  n = initialN(params),
  n_pp = initialNResource(params),
  n_other = initialNOther(params),
  e = getEReproAndGrowth(params, n = n, n_pp = n_pp, n_other = n_other)
)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{e}{The energy available for reproduction and growth (optional). A
matrix of size no. species x no. size bins. If not supplied, is calculated
internally using \code{\link[=getEReproAndGrowth]{getEReproAndGrowth()}}.}
}
\value{
A two dimensional array (prey species x prey size) holding
\deqn{\psi_i(w)E_{r.i}(w)}
where \eqn{E_{r.i}(w)} is the rate at which energy becomes available for
growth and reproduction, calculated with \code{\link[=getEReproAndGrowth]{getEReproAndGrowth()}},
and \eqn{\psi_i(w)} is the proportion of this energy that is used for
reproduction. This proportion is taken from the \code{params} object and is
set with \code{\link[=setReproduction]{setReproduction()}}.
}
\description{
Calculates the energy rate (grams/year) available for reproduction after
growth and metabolism have been accounted for.
}
\examples{
\dontrun{
params <- newMultispeciesParams(NS_species_params_gears, inter)
# Project with constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
# Get the energy at a particular time step
getERepro(params,sim@n[21,,],sim@n_pp[21,])
}
}
\seealso{
Other rate functions: 
\code{\link{getEGrowth}()},
\code{\link{getEReproAndGrowth}()},
\code{\link{getEncounter}()},
\code{\link{getFMortGear}()},
\code{\link{getFMort}()},
\code{\link{getFeedingLevel}()},
\code{\link{getMort}()},
\code{\link{getPredMort}()},
\code{\link{getPredRate}()},
\code{\link{getRDD}()},
\code{\link{getRDI}()},
\code{\link{getResourceMort}()}
}
\concept{rate functions}
