% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setFishing.R
\name{setFishing}
\alias{setFishing}
\alias{getCatchability}
\alias{getSelectivity}
\alias{getInitialEffort}
\title{Set fishing parameters}
\usage{
setFishing(
  params,
  selectivity = NULL,
  catchability = NULL,
  comment_selectivity = "set manually",
  comment_catchability = "set manually",
  initial_effort = NULL,
  ...
)

getCatchability(params)

getSelectivity(params)

getInitialEffort(params)
}
\arguments{
\item{params}{A MizerParams object}

\item{selectivity}{Optional. An array (gear x species x size) that holds the
selectivity of each gear for species and size, \eqn{S_{g,i,w}}.}

\item{catchability}{Optional. An array (gear x species) that holds the catchability of
each species by each gear, \eqn{Q_{g,i}}.}

\item{comment_selectivity}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
A string describing how the value for 'selectivity' was obtained. This is
ignored if 'selectivity' is not supplied or already has a comment
attribute.}

\item{comment_catchability}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
A string describing how the value for 'catchability' was obtained. This is
ignored if 'catchability' is not supplied or already has a comment
attribute.}

\item{initial_effort}{Optional. A number or a named numeric vector specifying
the fishing effort. If a number, the same effort is used for all gears. If
a vector, must be named by gear.}

\item{...}{Unused}
}
\value{
MizerParams object with updated catchability and selectivity. Because
of the way the R language works, \code{setFishing()} does not make the changes
to the params object that you pass to it but instead returns a new params
object. So to affect the change you call the function in the form
\code{params <- setFishing(params, ...)}.
}
\description{
Set fishing parameters
}
\section{Setting fishing}{


\strong{Gears}

In \code{mizer}, fishing mortality is imposed on species by fishing gears. The
total per-capita fishing mortality (1/year) is obtained by summing over the
mortality from all gears,
\deqn{\mu_{f.i}(w) = \sum_g F_{g,i}(w),}
where the fishing mortality \eqn{F_{g,i}(w)} imposed by gear \eqn{g} on
species \eqn{i} at size \eqn{w} is calculated as:
\deqn{F_{g,i}(w) = S_{g,i}(w) Q_{g,i} E_{g},}
where \eqn{S} is the selectivity by species, gear and size, \eqn{Q} is the
catchability by species and gear and \eqn{E} is the fishing effort by gear.

\strong{Selectivity}

The selectivity at size of each gear for each species is saved as a three
dimensional array (gear x species x size). Each entry has a range between 0
(that gear is not selecting that species at that size) to 1 (that gear is
selecting all individuals of that species of that size). This three
dimensional array can be specified explicitly via the \code{selectivity}
argument, but usually mizer calculates it from the \code{gear_params} slot of
the MizerParams object.

To allow the calculation of the \code{selectivity} array, the \code{gear_params} slot
must be a data frame with one row for each gear-species combination. So if
for example a gear can select three species, then that gear contributes three
rows to the \code{gear_params} data frame, one for each species it can select. The
data frame must have columns \code{gear}, holding the name of the gear, \code{species},
holding the name of the species, and \code{sel_func}, holding the name of the
function that calculates the selectivity curve. Some selectivity functions
are included in the package: \code{knife_edge()}, \code{sigmoid_length()},
\code{double_sigmoid_length()}, and \code{sigmoid_weight()}.
Users are able to write their own size-based selectivity function. The first
argument to the function must be \code{w} and the function must return a vector of
the selectivity (between 0 and 1) at size.

Each selectivity function may have parameters. Values for these
parameters must be included as columns in the gear parameters data.frame.
The names of the columns must exactly match the names of the corresponding
arguments of the selectivity function. For example, the default selectivity
function is \code{knife_edge()} that a has sudden change of selectivity from 0 to 1
at a certain size. In its help page you can see that the \code{knife_edge()}
function has arguments \code{w} and \code{knife_edge_size}. The first argument, \code{w}, is
size (the function calculates selectivity at size). All selectivity functions
must have \code{w} as the first argument. The values for the other arguments must
be found in the gear parameters data.frame. So for the \code{knife_edge()}
function there should be a \code{knife_edge_size} column. Because \code{knife_edge()}
is the default selectivity function, the \code{knife_edge_size} argument has a
default value = \code{w_mat}.

In case each species is only selected by one gear, the columns of the
\code{gear_params} data frame can alternatively be provided as columns of the
\code{species_params} data frame, if this is more convenient for the user to set
up. Mizer will then copy these columns over to create the \code{gear_params} data
frame when it creates the MizerParams object. However changing these columns
in the species parameter data frame later will not update the \code{gear_params}
data frame.

\strong{Catchability}

Catchability is used as an additional factor to make the link between gear
selectivity, fishing effort and fishing mortality. For example, it can be set
so that an effort of 1 gives a desired fishing mortality. In this way effort
can then be specified relative to a 'base effort', e.g. the effort in a
particular year.

Catchability is stored as a two dimensional array (gear x species). This can
either be provided explicitly via the \code{catchability} argument, or the
information can be provided via a \code{catchability} column in the \code{gear_params}
data frame.

In the case where each species is selected by only a single gear, the
\code{catchability} column can also be provided in the \code{species_params} data
frame. Mizer will then copy this over to the \code{gear_params} data frame when
the MizerParams object is created.

\strong{Effort}

The initial fishing effort is stored in the \code{MizerParams} object. If it is
not supplied, it is set to zero. The initial effort can be overruled when
the simulation is run with \code{project()}, where it is also possible to specify
an effort that varies through time.
}

\seealso{
\code{\link[=gear_params]{gear_params()}}

Other functions for setting parameters: 
\code{\link{gear_params}()},
\code{\link{resource_params}()},
\code{\link{setExtMort}()},
\code{\link{setInitialValues}()},
\code{\link{setInteraction}()},
\code{\link{setMaxIntakeRate}()},
\code{\link{setMetabolicRate}()},
\code{\link{setParams}()},
\code{\link{setPredKernel}()},
\code{\link{setReproduction}()},
\code{\link{setResource}()},
\code{\link{setSearchVolume}()},
\code{\link{species_params}()}
}
\concept{functions for setting parameters}
