\name{mlbench.cassini}
\title{Cassini: A 2 Dimensional Problem}
\usage{
mlbench.cassini(n, relsize=c(2,2,1))
}
\arguments{
    \item{n}{number of patterns to create}
    \item{relsize}{relative size of the classes (vector of length 3)}
}
\value{Returns an object of class \code{"mlbench.cassini"}  with components
    \item{x}{input values}
    \item{classes}{vector of length \code{n} with target classes} 
}
\description{
    The inputs of the cassini problem are uniformly distributed on
    a \code{2}-dimensional space within 3 structures. The 2 external
    structures (classes) are banana-shaped structures and in between them, the
    middle structure (class) is a circle.
}

\author{Evgenia Dimitriadou, and Andreas Weingessel}

\examples{
p_mlbench.cassini(5000)
plot.mlbench(p)
}


