% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{[.mldr}
\alias{[.mldr}
\title{Filter rows in a\code{mldr} returning a new \code{mldr}}
\usage{
\method{[}{mldr}(mldrObject, rowFilter = T)
}
\arguments{
\item{mldrObject}{Original \code{mldr} object from which some rows are going to be selected}

\item{rowFilter}{Expression to filter the rows}
}
\value{
A new \code{mldr} object with the selected rows
}
\description{
Generates a new \code{mldr} object containing the selected
rows from an existent \code{mldr}
}
\examples{

library(mldr)

highlycoupled <- genbase[.SCUMBLE > 0.05] # Select instances with highly imbalanced coupled labels
summary(highlycoupled)   # Compare the selected instances
summary(genbase)         # with the traits of the original MLD

}
\seealso{
\code{\link{mldr_from_dataframe}}, \code{\link{==.mldr}}, \code{\link{+.mldr}}
}
