% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_mlnet.R
\name{simulate_mlnet}
\alias{simulate_mlnet}
\title{Simulate a multilevel network}
\usage{
simulate_mlnet(form, node_memb, theta, parameterization = "standard",
  seed = NULL, between_form = NULL, between_theta = NULL,
  between_prob = NULL, options = set_options())
}
\arguments{
\item{form}{A \code{\link{formula}} object of the form \code{network ~ model terms} which specifies how the within-block subgraphs are modeled.}

\item{node_memb}{Vector of node block memberships.}

\item{theta}{A vector of model parameters (coefficients) for the ERGM governing the within-subgraph edges.}

\item{parameterization}{Character vector indicating if the \code{standard} (non-size adjusted) parameterization should be used or if the \code{offset} size adjusted parameterization should be used.}

\item{seed}{Seed to be provided for reproducibility.}

\item{between_form}{A \code{\link{formula}} object of the form \code{~ model terms} which specifies how the within-block subgraphs are modeled.}

\item{between_theta}{A vector of model parameters (coefficients) for the ERGM governing the between-subgraph edges.}

\item{between_prob}{A probability which specifies how edges between blocks are governerd. An ERGM (\code{between_form} and \code{between_theta}) cannot be specified together with \code{between_prob}.}

\item{options}{Use \code{\link{set_options}} to change the simulation options. Note that some options are only valid for estimation using \code{\link{mlergm}}.}
}
\value{
\code{simulate_mlnet} returns an objects of class \code{\link{mlnet}}.
}
\description{
Function simulates a multilevel network by specifying a network size, node block memberships, and within-block and between-block models. The function currently only suppports block-models where between-block edges are dyad-independent.
}
\details{
Simulation of multilevel block networks is done with a Monte-Carlo Markov chain (MCMC) and can be done in parallel where \code{\link{set_options}} can be used to adjust the simulation settings (such as \code{burnin}, \code{interval}, and \code{sample_size}). Each within-block subgraph is given its own Markov chain, and so these settings are the settings to be used for each within-block chain.
}
\examples{

# Create a K = 2 block network with edge + gwesp term 
net <- simulate_mlnet(form = network.initialize(40, directed = FALSE) ~ edges + gwesp, 
                      node_memb = c(rep(1, 20), rep(2, 20)),
                      theta = c(-3, 0.5, 1.0), 
                      between_prob = 0.01,
                      options = set_options(number_cores = 2, burnin = 5000))

# Simulate a K = 2 block directed network, specifying a formula for between edges
net <- simulate_mlnet(form = network.initialize(40, directed = TRUE) ~ edges + gwesp,
                      node_memb = c(rep(1, 20), rep(2, 20)),
                      theta = c(-3, 0.5, 1.0),
                      between_form = ~ edges + mutual, 
                      between_theta = c(-4, 2),
                      options = set_options(number_cores = 2, burnin = 5000))
}
\keyword{simulation}
