% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLTuneParameters.R
\name{MLTuneParameters}
\alias{MLTuneParameters}
\title{R6 Class to perform hyperparameter tuning experiments}
\description{
The \code{MLTuneParameters} class is used to construct a parameter tuner object
and to perform the tuning of a set of hyperparameters for a specified
machine learning algorithm using either a grid search or a Bayesian
optimization.
}
\details{
The hyperparameter tuning can be performed with a grid search or a Bayesian
optimization. In both cases, each hyperparameter setting is evaluated in a
k-fold cross-validation on the dataset specified.
}
\examples{
knn_tuner <- MLTuneParameters$new(
  learner = LearnerKnn$new(),
  seed = 123,
  strategy = "grid",
  ncores = 2
)


## ------------------------------------------------
## Method `MLTuneParameters$new`
## ------------------------------------------------

MLTuneParameters$new(
  learner = LearnerKnn$new(),
  seed = 123,
  strategy = "grid",
  ncores = 2
)


## ------------------------------------------------
## Method `MLTuneParameters$execute`
## ------------------------------------------------

dataset <- do.call(
  cbind,
  c(sapply(paste0("col", 1:6), function(x) {
    rnorm(n = 500)
    },
    USE.NAMES = TRUE,
    simplify = FALSE
   ),
   list(target = sample(0:1, 500, TRUE))
))
tuner <- MLTuneParameters$new(
  learner = LearnerKnn$new(),
  seed = 123,
  strategy = "grid",
  ncores = 2
)
tuner$parameter_bounds <- list(k = c(2L, 80L))
tuner$parameter_grid <- expand.grid(
  k = seq(4, 68, 8),
  l = 0,
  test = parse(text = "fold_test$x")
)
tuner$split_type <- "stratified"
tuner$optim_args <- list(
  iters.n = 4,
  kappa = 3.5,
  acq = "ucb"
)

# set data
tuner$set_data(
  x = data.matrix(dataset[, -7]),
  y = dataset[, 7]
)

tuner$execute(k = 3)

}
\seealso{
\code{\link[ParBayesianOptimization:bayesOpt]{ParBayesianOptimization::bayesOpt()}}, \code{\link[splitTools:create_folds]{splitTools::create_folds()}}
}
\section{Super classes}{
\code{\link[mlexperiments:MLBase]{mlexperiments::MLBase}} -> \code{\link[mlexperiments:MLExperimentsBase]{mlexperiments::MLExperimentsBase}} -> \code{MLTuneParameters}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{parameter_bounds}}{A named list of tuples to define the parameter
bounds of the Bayesian hyperparameter optimization. For further details
please see the documentation of the \code{ParBayesianOptimization} package.}

\item{\code{parameter_grid}}{A matrix with named columns in which each column
represents a parameter that should be optimized and each row represents
a specific hyperparameter setting that should be tested throughout the
procedure. For \code{strategy = "grid"}, each row of the \code{parameter_grid} is
considered as a setting that is evaluated. For \code{strategy = "bayesian"},
the \code{parameter_grid} is passed further on to the \code{initGrid} argument of
the function \code{\link[ParBayesianOptimization:bayesOpt]{ParBayesianOptimization::bayesOpt()}} in order to
initialize the Bayesian process. The maximum rows considered for
initializing the Bayesian process can be specified with the R option
\code{option("mlexperiments.bayesian.max_init")}, which is set to \code{50L} by
default.}

\item{\code{optim_args}}{A named list of tuples to define the parameter
bounds of the Bayesian hyperparameter optimization. For further details
please see the documentation of the \code{ParBayesianOptimization} package.}

\item{\code{split_type}}{A character. The splitting strategy to construct the
k cross-validation folds. This parameter is passed further on to the
function \code{\link[splitTools:create_folds]{splitTools::create_folds()}} and defaults to \code{"stratified"}.}

\item{\code{split_vector}}{A vector If another criteria than the provided \code{y}
should be considered for generating the cross-validation folds, it can
be defined here. It is important, that a vector of the same length as
\code{x} is provided here.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MLTuneParameters-new}{\code{MLTuneParameters$new()}}
\item \href{#method-MLTuneParameters-execute}{\code{MLTuneParameters$execute()}}
\item \href{#method-MLTuneParameters-clone}{\code{MLTuneParameters$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLExperimentsBase" data-id="set_data"><a href='../../mlexperiments/html/MLExperimentsBase.html#method-MLExperimentsBase-set_data'><code>mlexperiments::MLExperimentsBase$set_data()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MLTuneParameters-new"></a>}}
\if{latex}{\out{\hypertarget{method-MLTuneParameters-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{MLTuneParameters} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MLTuneParameters$new(
  learner,
  seed,
  strategy = c("grid", "bayesian"),
  ncores = -1L
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{learner}}{An initialized learner object that inherits from class
\code{"MLLearnerBase"}.}

\item{\code{seed}}{An integer. Needs to be set for reproducibility purposes.}

\item{\code{strategy}}{A character. The strategy to optimize the hyperparameters
(either \code{"grid"} or \code{"bayesian"}).}

\item{\code{ncores}}{An integer to specify the number of cores used for
parallelization (default: \code{-1L}).}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
For \code{strategy = "bayesian"}, the number of starting iterations can be
set using the R option \code{"mlexperiments.bayesian.max_init"}, which
defaults to \code{50L}. This option reduces the provided initialization
grid to contain at most the specified number of rows. This
initialization grid is then further passed on to the \code{initGrid}
argument of \link[ParBayesianOptimization:bayesOpt]{ParBayesianOptimization::bayesOpt}.
}

\subsection{Returns}{
A new \code{MLTuneParameters} R6 object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{MLTuneParameters$new(
  learner = LearnerKnn$new(),
  seed = 123,
  strategy = "grid",
  ncores = 2
)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MLTuneParameters-execute"></a>}}
\if{latex}{\out{\hypertarget{method-MLTuneParameters-execute}{}}}
\subsection{Method \code{execute()}}{
Execute the hyperparameter tuning.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MLTuneParameters$execute(k)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{k}}{An integer to define the number of cross-validation folds used
to tune the hyperparameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
All results of the hyperparameter tuning are saved in the field
\verb{$results} of the \code{MLTuneParameters} class. After successful execution
of the parameter tuning, \verb{$results} contains a list with the items
\describe{
\item{"summary"}{A data.table with the summarized results (same as
the returned value of the \code{execute} method).}
\item{"best.setting"}{The best setting (according to the learner's
parameter \code{metric_optimization_higher_better}) identified during the
hyperparameter tuning.}
\item{"bayesOpt"}{The returned value of
\code{\link[ParBayesianOptimization:bayesOpt]{ParBayesianOptimization::bayesOpt()}} (only for \code{strategy = "bayesian"}).}
}
}

\subsection{Returns}{
A \code{data.table} with the results of the hyperparameter
optimization. The optimized metric, i.e. the cross-validated evaluation
metric is given in the column \code{metric_optim_mean}. More results are
accessible from the field \verb{$results} of the \code{MLTuneParameters} class.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dataset <- do.call(
  cbind,
  c(sapply(paste0("col", 1:6), function(x) {
    rnorm(n = 500)
    },
    USE.NAMES = TRUE,
    simplify = FALSE
   ),
   list(target = sample(0:1, 500, TRUE))
))
tuner <- MLTuneParameters$new(
  learner = LearnerKnn$new(),
  seed = 123,
  strategy = "grid",
  ncores = 2
)
tuner$parameter_bounds <- list(k = c(2L, 80L))
tuner$parameter_grid <- expand.grid(
  k = seq(4, 68, 8),
  l = 0,
  test = parse(text = "fold_test$x")
)
tuner$split_type <- "stratified"
tuner$optim_args <- list(
  iters.n = 4,
  kappa = 3.5,
  acq = "ucb"
)

# set data
tuner$set_data(
  x = data.matrix(dataset[, -7]),
  y = dataset[, 7]
)

tuner$execute(k = 3)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MLTuneParameters-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MLTuneParameters-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MLTuneParameters$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
