% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner_knn.R
\name{LearnerKnn}
\alias{LearnerKnn}
\title{LearnerKnn R6 class}
\description{
This learner is a wrapper around \code{\link[class:knn]{class::knn()}} in order to perform a
k-nearest neighbor classification.
}
\details{
Optimization metric: classification error rate
Can be used with
\itemize{
\item \link{MLTuneParameters}
\item \link{MLCrossValidation}
\item \link{MLNestedCV}
}

Implemented methods:
\itemize{
\item \verb{$fit} To fit the model.
\item \verb{$predict} To predict new data with the model.
\item \verb{$cross_validation} To perform a grid search (hyperparameter
optimization).
\item \verb{$bayesian_scoring_function} To perform a Bayesian hyperparameter
optimization.
}

For the two hyperparameter optimization strategies ("grid" and "bayesian"),
the parameter \code{metric_optimization_higher_better} of the learner is
set to \code{FALSE} by default as the classification error rate
(\code{\link[mlr3measures:ce]{mlr3measures::ce()}}) is used as the optimization metric.
}
\examples{
LearnerKnn$new()


## ------------------------------------------------
## Method `LearnerKnn$new`
## ------------------------------------------------

LearnerKnn$new()

}
\seealso{
\code{\link[class:knn]{class::knn()}}, \code{\link[mlr3measures:ce]{mlr3measures::ce()}}

\code{\link[class:knn]{class::knn()}}, \code{\link[mlr3measures:ce]{mlr3measures::ce()}}
}
\section{Super class}{
\code{\link[mlexperiments:MLLearnerBase]{mlexperiments::MLLearnerBase}} -> \code{LearnerKnn}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerKnn-new}{\code{LearnerKnn$new()}}
\item \href{#method-LearnerKnn-clone}{\code{LearnerKnn$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="bayesian_scoring_function"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-bayesian_scoring_function'><code>mlexperiments::MLLearnerBase$bayesian_scoring_function()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="cross_validation"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-cross_validation'><code>mlexperiments::MLLearnerBase$cross_validation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="fit"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-fit'><code>mlexperiments::MLLearnerBase$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="predict"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-predict'><code>mlexperiments::MLLearnerBase$predict()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerKnn-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerKnn-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{LearnerKnn} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerKnn$new()}\if{html}{\out{</div>}}
}

\subsection{Details}{
This learner is a wrapper around \code{\link[class:knn]{class::knn()}} in order to perform a
k-nearest neighbor classification. The following experiments are
implemented:
\itemize{
\item \link{MLTuneParameters}
\item \link{MLCrossValidation}
\item \link{MLNestedCV}
For the two hyperparameter optimization strategies ("grid" and
"bayesian"), the parameter \code{metric_optimization_higher_better} of the
learner is set to \code{FALSE} by default as the classification error rate
(\code{\link[mlr3measures:ce]{mlr3measures::ce()}}) is used as the optimization metric.
}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{LearnerKnn$new()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerKnn-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerKnn-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerKnn$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
