# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Financial options using a Milstein discretisation
#'
#' Financial options based on scalar geometric Brownian motion, similar to
#' Mike Giles' MCQMC06 paper, using a Milstein discretisation
#'
#' This function is based on GPL-2 C++ code by Mike Giles.
#'
#' @param l the level to be simulated.
#' @param N the number of samples to be computed.
#' @param option the option type, between 1 and 5.  The options are: \describe{
#'   \item{1 = European call;}{}
#'   \item{2 = Asian call;}{}
#'   \item{3 = lookback call;}{}
#'   \item{4 = digital call;}{}
#'   \item{5 = barrier call.}{}
#' }
#'
#' @author Louis Aslett <aslett@stats.ox.ac.uk>
#' @author Mike Giles <Mike.Giles@maths.ox.ac.uk>
#'
#' @references
#' M.B. Giles. 'Improved multilevel Monte Carlo convergence using the Milstein scheme', p.343-358 in \emph{Monte Carlo and Quasi-Monte Carlo Methods 2006}, Springer, 2007.
#'
#' @examples
#' \dontrun{
#' # These are similar to the MLMC tests for the MCQMC06 paper
#' # using a Milstein discretisation with 2^l timesteps on level l
#' #
#' # The figures are slightly different due to:
#' # -- change in MSE split
#' # -- change in cost calculation
#' # -- different random number generation
#' # -- switch to S_0=100
#'
#' M    <- 2 # refinement cost factor
#' N0   <- 200 # initial samples on coarse levels
#' Lmin <- 2 # minimum refinement level
#' Lmax <- 10 # maximum refinement level
#'
#' test.res <- list()
#' for(option in 1:5) {
#'   if(option==1) {
#'     cat("\n ---- Computing European call ---- \n")
#'     N      <- 20000 # samples for convergence tests
#'     L      <- 8 # levels for convergence tests
#'     Eps    <- c(0.005, 0.01, 0.02, 0.05, 0.1)
#'   } else if(option==2) {
#'     cat("\n ---- Computing Asian call ---- \n")
#'     N      <- 20000 # samples for convergence tests
#'     L      <- 8 # levels for convergence tests
#'     Eps    <- c(0.005, 0.01, 0.02, 0.05, 0.1)
#'   } else if(option==3) {
#'     cat("\n ---- Computing lookback call ---- \n")
#'     N      <- 20000 # samples for convergence tests
#'     L      <- 10 # levels for convergence tests
#'     Eps    <- c(0.005, 0.01, 0.02, 0.05, 0.1)
#'   } else if(option==4) {
#'     cat("\n ---- Computing digital call ---- \n")
#'     N      <- 200000 # samples for convergence tests
#'     L      <- 8 # levels for convergence tests
#'     Eps    <- c(0.01, 0.02, 0.05, 0.1, 0.2)
#'   } else if(option==5) {
#'     cat("\n ---- Computing barrier call ---- \n")
#'     N      <- 200000 # samples for convergence tests
#'     L      <- 8 # levels for convergence tests
#'     Eps    <- c(0.005, 0.01, 0.02, 0.05, 0.1)
#'   }
#'
#'   test.res[[option]] <- mlmc.test(mcqmc06_l, M, N, L, N0, Eps, Lmin, Lmax, option=option)
#'
#'   # plot results
#'   plot(test.res[[option]])
#' }
#' }
#'
#' # The level sampler can be called directly to retrieve the relevant level sums:
#' mcqmc06_l(l=7, N=10, option=1)
#'
#' @export
mcqmc06_l <- function(l, N, option) {
    .Call('mlmc_mcqmc06_l', PACKAGE = 'mlmc', l, N, option)
}

