% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncv_tests.R
\name{ncv_tests}
\alias{ncv_tests}
\title{Non-constant Variance Tests at Level-1 (experimental)}
\usage{
ncv_tests(model, formula = NULL, verbose = FALSE)
}
\arguments{
\item{model}{a mixed model produced using the \code{lme4} package and the \code{lmer()} function. This is an object of class \code{merMod} and subclass \code{lmerMod}. Currently, only supports 2-level models.}

\item{formula}{level-1 formula to compute H test. Formula should be of the form \eqn{y \sim x_1 + ... + x_n \; | \; g} where \eqn{y} is the response, \eqn{x_1 + ... + x_n} are the covariates, and \eqn{g} is the grouping factor, see \code{lme4::lmList} for details.}

\item{verbose}{return additional statistics including d-values and outliers from H test; adjusted R-squared, ANOVA results, and mean residual by cluster for Levene test; and likelihood ratio test for B-P test.}
}
\value{
A list containing results from the three non-constant variance tests.
}
\description{
Computes three different Non-constant variance tests: the H test as discussed in Raudenbush and Bryk (2002, pp. 263-265) and Snijders and Bosker (2012, p. 159-160), an approximate Levene's test discussed by Hox et al. (2018, p. 238), and a variation of the Breusch-Pagan test.

For the H test, the user must specify the level-1 formula. This test computes a standardized measure of dispersion for each level-2 group and detects heteroscedasticity in the form of between-group differences in the level-one residuals variances. The standardized measure of dispersion is based on estimated ordinary least squares residuals in each group.

The Levene's test computes a oneway analysis of variance of the level-2 grouping variable on the squared residuals of the model. This test examines whether the variance of the residuals is the same in all groups.

The Breusch-Pagan test regresses the squared residuals on the fitted model. A likelihood ratio test is used to compare this model with a with a null model that regresses the squared residuals on an empty model with the same random effects. This test examines whether the variance of the residuals depends on the predictor variables.
}
\examples{

fit <- lme4::lmer(mathach ~ 1 + ses + catholic + (1|id), data=hsb, REML=FALSE)

ncv_tests(fit)

# extract outliers from H test
test <- ncv_tests(fit, formula = mathach ~ 1 + ses | id, verbose = TRUE)
test$H_test$outliers

}
\references{
{
\insertRef{hox2018}{mlmhelpr}
}

{
\insertRef{raudenbush2002}{mlmhelpr}
}

{
\insertRef{singer2003}{mlmhelpr}
}
}
