% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2_pve.R
\name{r2_pve}
\alias{r2_pve}
\title{Proportion of variance explained}
\usage{
r2_pve(model1, model2 = NULL)
}
\arguments{
\item{model1}{Previous model, produced using the \code{lme4::lmer()} function. Usually, this is the null or unconditional model.}

\item{model2}{Current model, produced using the \code{lme4::lmer()} function.}
}
\value{
Data frame containing the proportion of variance explained at each level
}
\description{
\code{r2_pve} calculates the proportional reduction in variance explained (PVE) by adding variables to a prior, nested model. The PVE is considered a local effect size estimate (Peugh, 2010; Raudenbush & Bryk, 2002).
}
\examples{
fit1 <- lme4::lmer(mathach ~ 1 + (1|id), data=hsb, REML=FALSE)
fit2 <- lme4::lmer(mathach ~ 1 + ses + (1|id), data=hsb, REML=FALSE)

r2_pve(fit1, fit2)
}
\references{
{
\insertRef{peugh2010}{mlmhelpr}
}

{
\insertRef{raudenbush2002}{mlmhelpr}
}
}
