
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.16.0

#include <stan/model/model_header.hpp>

namespace model_mlmc_code_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_mlmc_code");
    reader.add_event(135, 135, "end", "model_mlmc_code");
    return reader;
}

class model_mlmc_code : public prob_grad {
private:
    int nobs;
    int ncensor;
    int nmiss;
    int npred;
    int npred_miss;
    int npred_sub;
    int nsid;
    int np;
    int respond_dep;
    vector<int> sid;
    vector<int> sid_m;
    vector<int> pid;
    vector<int> pid_m;
    matrix_d pred;
    matrix_d pred_m;
    matrix_d pred_miss;
    matrix_d pred_miss_m;
    matrix_d pred_sub;
    matrix_d pred_sub_m;
    vector<double> y;
    vector<int> miss_m;
    vector<int> miss_obs;
    matrix_d R;
    vector_d Sigma_sd;
    matrix_d prec;
    vector_d mn;
    double censor_lim;
    vector<int> sid_c;
    vector<int> pid_c;
    matrix_d pred_c;
    matrix_d pred_sub_c;
    matrix_d T;
    matrix_d invprec;
public:
    model_mlmc_code(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_mlmc_code(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_mlmc_code_namespace::model_mlmc_code";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "nobs", "int", context__.to_vec());
        nobs = int(0);
        vals_i__ = context__.vals_i("nobs");
        pos__ = 0;
        nobs = vals_i__[pos__++];
        context__.validate_dims("data initialization", "ncensor", "int", context__.to_vec());
        ncensor = int(0);
        vals_i__ = context__.vals_i("ncensor");
        pos__ = 0;
        ncensor = vals_i__[pos__++];
        context__.validate_dims("data initialization", "nmiss", "int", context__.to_vec());
        nmiss = int(0);
        vals_i__ = context__.vals_i("nmiss");
        pos__ = 0;
        nmiss = vals_i__[pos__++];
        context__.validate_dims("data initialization", "npred", "int", context__.to_vec());
        npred = int(0);
        vals_i__ = context__.vals_i("npred");
        pos__ = 0;
        npred = vals_i__[pos__++];
        context__.validate_dims("data initialization", "npred_miss", "int", context__.to_vec());
        npred_miss = int(0);
        vals_i__ = context__.vals_i("npred_miss");
        pos__ = 0;
        npred_miss = vals_i__[pos__++];
        context__.validate_dims("data initialization", "npred_sub", "int", context__.to_vec());
        npred_sub = int(0);
        vals_i__ = context__.vals_i("npred_sub");
        pos__ = 0;
        npred_sub = vals_i__[pos__++];
        context__.validate_dims("data initialization", "nsid", "int", context__.to_vec());
        nsid = int(0);
        vals_i__ = context__.vals_i("nsid");
        pos__ = 0;
        nsid = vals_i__[pos__++];
        context__.validate_dims("data initialization", "np", "int", context__.to_vec());
        np = int(0);
        vals_i__ = context__.vals_i("np");
        pos__ = 0;
        np = vals_i__[pos__++];
        context__.validate_dims("data initialization", "respond_dep", "int", context__.to_vec());
        respond_dep = int(0);
        vals_i__ = context__.vals_i("respond_dep");
        pos__ = 0;
        respond_dep = vals_i__[pos__++];
        validate_non_negative_index("sid", "nobs", nobs);
        context__.validate_dims("data initialization", "sid", "int", context__.to_vec(nobs));
        validate_non_negative_index("sid", "nobs", nobs);
        sid = std::vector<int>(nobs,int(0));
        vals_i__ = context__.vals_i("sid");
        pos__ = 0;
        size_t sid_limit_0__ = nobs;
        for (size_t i_0__ = 0; i_0__ < sid_limit_0__; ++i_0__) {
            sid[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("sid_m", "nmiss", nmiss);
        context__.validate_dims("data initialization", "sid_m", "int", context__.to_vec(nmiss));
        validate_non_negative_index("sid_m", "nmiss", nmiss);
        sid_m = std::vector<int>(nmiss,int(0));
        vals_i__ = context__.vals_i("sid_m");
        pos__ = 0;
        size_t sid_m_limit_0__ = nmiss;
        for (size_t i_0__ = 0; i_0__ < sid_m_limit_0__; ++i_0__) {
            sid_m[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("pid", "nobs", nobs);
        context__.validate_dims("data initialization", "pid", "int", context__.to_vec(nobs));
        validate_non_negative_index("pid", "nobs", nobs);
        pid = std::vector<int>(nobs,int(0));
        vals_i__ = context__.vals_i("pid");
        pos__ = 0;
        size_t pid_limit_0__ = nobs;
        for (size_t i_0__ = 0; i_0__ < pid_limit_0__; ++i_0__) {
            pid[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("pid_m", "nmiss", nmiss);
        context__.validate_dims("data initialization", "pid_m", "int", context__.to_vec(nmiss));
        validate_non_negative_index("pid_m", "nmiss", nmiss);
        pid_m = std::vector<int>(nmiss,int(0));
        vals_i__ = context__.vals_i("pid_m");
        pos__ = 0;
        size_t pid_m_limit_0__ = nmiss;
        for (size_t i_0__ = 0; i_0__ < pid_m_limit_0__; ++i_0__) {
            pid_m[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("pred", "nobs", nobs);
        validate_non_negative_index("pred", "npred", npred);
        context__.validate_dims("data initialization", "pred", "matrix_d", context__.to_vec(nobs,npred));
        validate_non_negative_index("pred", "nobs", nobs);
        validate_non_negative_index("pred", "npred", npred);
        pred = matrix_d(static_cast<Eigen::VectorXd::Index>(nobs),static_cast<Eigen::VectorXd::Index>(npred));
        vals_r__ = context__.vals_r("pred");
        pos__ = 0;
        size_t pred_m_mat_lim__ = nobs;
        size_t pred_n_mat_lim__ = npred;
        for (size_t n_mat__ = 0; n_mat__ < pred_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < pred_m_mat_lim__; ++m_mat__) {
                pred(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("pred_m", "nmiss", nmiss);
        validate_non_negative_index("pred_m", "npred", npred);
        context__.validate_dims("data initialization", "pred_m", "matrix_d", context__.to_vec(nmiss,npred));
        validate_non_negative_index("pred_m", "nmiss", nmiss);
        validate_non_negative_index("pred_m", "npred", npred);
        pred_m = matrix_d(static_cast<Eigen::VectorXd::Index>(nmiss),static_cast<Eigen::VectorXd::Index>(npred));
        vals_r__ = context__.vals_r("pred_m");
        pos__ = 0;
        size_t pred_m_m_mat_lim__ = nmiss;
        size_t pred_m_n_mat_lim__ = npred;
        for (size_t n_mat__ = 0; n_mat__ < pred_m_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < pred_m_m_mat_lim__; ++m_mat__) {
                pred_m(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("pred_miss", "nobs", nobs);
        validate_non_negative_index("pred_miss", "npred_miss", npred_miss);
        context__.validate_dims("data initialization", "pred_miss", "matrix_d", context__.to_vec(nobs,npred_miss));
        validate_non_negative_index("pred_miss", "nobs", nobs);
        validate_non_negative_index("pred_miss", "npred_miss", npred_miss);
        pred_miss = matrix_d(static_cast<Eigen::VectorXd::Index>(nobs),static_cast<Eigen::VectorXd::Index>(npred_miss));
        vals_r__ = context__.vals_r("pred_miss");
        pos__ = 0;
        size_t pred_miss_m_mat_lim__ = nobs;
        size_t pred_miss_n_mat_lim__ = npred_miss;
        for (size_t n_mat__ = 0; n_mat__ < pred_miss_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < pred_miss_m_mat_lim__; ++m_mat__) {
                pred_miss(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("pred_miss_m", "nmiss", nmiss);
        validate_non_negative_index("pred_miss_m", "npred_miss", npred_miss);
        context__.validate_dims("data initialization", "pred_miss_m", "matrix_d", context__.to_vec(nmiss,npred_miss));
        validate_non_negative_index("pred_miss_m", "nmiss", nmiss);
        validate_non_negative_index("pred_miss_m", "npred_miss", npred_miss);
        pred_miss_m = matrix_d(static_cast<Eigen::VectorXd::Index>(nmiss),static_cast<Eigen::VectorXd::Index>(npred_miss));
        vals_r__ = context__.vals_r("pred_miss_m");
        pos__ = 0;
        size_t pred_miss_m_m_mat_lim__ = nmiss;
        size_t pred_miss_m_n_mat_lim__ = npred_miss;
        for (size_t n_mat__ = 0; n_mat__ < pred_miss_m_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < pred_miss_m_m_mat_lim__; ++m_mat__) {
                pred_miss_m(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("pred_sub", "nobs", nobs);
        validate_non_negative_index("pred_sub", "npred_sub", npred_sub);
        context__.validate_dims("data initialization", "pred_sub", "matrix_d", context__.to_vec(nobs,npred_sub));
        validate_non_negative_index("pred_sub", "nobs", nobs);
        validate_non_negative_index("pred_sub", "npred_sub", npred_sub);
        pred_sub = matrix_d(static_cast<Eigen::VectorXd::Index>(nobs),static_cast<Eigen::VectorXd::Index>(npred_sub));
        vals_r__ = context__.vals_r("pred_sub");
        pos__ = 0;
        size_t pred_sub_m_mat_lim__ = nobs;
        size_t pred_sub_n_mat_lim__ = npred_sub;
        for (size_t n_mat__ = 0; n_mat__ < pred_sub_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < pred_sub_m_mat_lim__; ++m_mat__) {
                pred_sub(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("pred_sub_m", "nmiss", nmiss);
        validate_non_negative_index("pred_sub_m", "npred_sub", npred_sub);
        context__.validate_dims("data initialization", "pred_sub_m", "matrix_d", context__.to_vec(nmiss,npred_sub));
        validate_non_negative_index("pred_sub_m", "nmiss", nmiss);
        validate_non_negative_index("pred_sub_m", "npred_sub", npred_sub);
        pred_sub_m = matrix_d(static_cast<Eigen::VectorXd::Index>(nmiss),static_cast<Eigen::VectorXd::Index>(npred_sub));
        vals_r__ = context__.vals_r("pred_sub_m");
        pos__ = 0;
        size_t pred_sub_m_m_mat_lim__ = nmiss;
        size_t pred_sub_m_n_mat_lim__ = npred_sub;
        for (size_t n_mat__ = 0; n_mat__ < pred_sub_m_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < pred_sub_m_m_mat_lim__; ++m_mat__) {
                pred_sub_m(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("y", "nobs", nobs);
        context__.validate_dims("data initialization", "y", "double", context__.to_vec(nobs));
        validate_non_negative_index("y", "nobs", nobs);
        y = std::vector<double>(nobs,double(0));
        vals_r__ = context__.vals_r("y");
        pos__ = 0;
        size_t y_limit_0__ = nobs;
        for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
            y[i_0__] = vals_r__[pos__++];
        }
        validate_non_negative_index("miss_m", "nmiss", nmiss);
        context__.validate_dims("data initialization", "miss_m", "int", context__.to_vec(nmiss));
        validate_non_negative_index("miss_m", "nmiss", nmiss);
        miss_m = std::vector<int>(nmiss,int(0));
        vals_i__ = context__.vals_i("miss_m");
        pos__ = 0;
        size_t miss_m_limit_0__ = nmiss;
        for (size_t i_0__ = 0; i_0__ < miss_m_limit_0__; ++i_0__) {
            miss_m[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("miss_obs", "nobs", nobs);
        context__.validate_dims("data initialization", "miss_obs", "int", context__.to_vec(nobs));
        validate_non_negative_index("miss_obs", "nobs", nobs);
        miss_obs = std::vector<int>(nobs,int(0));
        vals_i__ = context__.vals_i("miss_obs");
        pos__ = 0;
        size_t miss_obs_limit_0__ = nobs;
        for (size_t i_0__ = 0; i_0__ < miss_obs_limit_0__; ++i_0__) {
            miss_obs[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("R", "npred", npred);
        validate_non_negative_index("R", "npred", npred);
        context__.validate_dims("data initialization", "R", "matrix_d", context__.to_vec(npred,npred));
        validate_non_negative_index("R", "npred", npred);
        validate_non_negative_index("R", "npred", npred);
        R = matrix_d(static_cast<Eigen::VectorXd::Index>(npred),static_cast<Eigen::VectorXd::Index>(npred));
        vals_r__ = context__.vals_r("R");
        pos__ = 0;
        size_t R_k_mat_lim__ = npred;
        for (size_t n_mat__ = 0; n_mat__ < R_k_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < R_k_mat_lim__; ++m_mat__) {
                R(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("Sigma_sd", "npred", npred);
        context__.validate_dims("data initialization", "Sigma_sd", "vector_d", context__.to_vec(npred));
        validate_non_negative_index("Sigma_sd", "npred", npred);
        Sigma_sd = vector_d(static_cast<Eigen::VectorXd::Index>(npred));
        vals_r__ = context__.vals_r("Sigma_sd");
        pos__ = 0;
        size_t Sigma_sd_i_vec_lim__ = npred;
        for (size_t i_vec__ = 0; i_vec__ < Sigma_sd_i_vec_lim__; ++i_vec__) {
            Sigma_sd[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("prec", "npred", npred);
        validate_non_negative_index("prec", "npred", npred);
        context__.validate_dims("data initialization", "prec", "matrix_d", context__.to_vec(npred,npred));
        validate_non_negative_index("prec", "npred", npred);
        validate_non_negative_index("prec", "npred", npred);
        prec = matrix_d(static_cast<Eigen::VectorXd::Index>(npred),static_cast<Eigen::VectorXd::Index>(npred));
        vals_r__ = context__.vals_r("prec");
        pos__ = 0;
        size_t prec_k_mat_lim__ = npred;
        for (size_t n_mat__ = 0; n_mat__ < prec_k_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < prec_k_mat_lim__; ++m_mat__) {
                prec(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("mn", "npred", npred);
        context__.validate_dims("data initialization", "mn", "vector_d", context__.to_vec(npred));
        validate_non_negative_index("mn", "npred", npred);
        mn = vector_d(static_cast<Eigen::VectorXd::Index>(npred));
        vals_r__ = context__.vals_r("mn");
        pos__ = 0;
        size_t mn_i_vec_lim__ = npred;
        for (size_t i_vec__ = 0; i_vec__ < mn_i_vec_lim__; ++i_vec__) {
            mn[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "censor_lim", "double", context__.to_vec());
        censor_lim = double(0);
        vals_r__ = context__.vals_r("censor_lim");
        pos__ = 0;
        censor_lim = vals_r__[pos__++];
        validate_non_negative_index("sid_c", "ncensor", ncensor);
        context__.validate_dims("data initialization", "sid_c", "int", context__.to_vec(ncensor));
        validate_non_negative_index("sid_c", "ncensor", ncensor);
        sid_c = std::vector<int>(ncensor,int(0));
        vals_i__ = context__.vals_i("sid_c");
        pos__ = 0;
        size_t sid_c_limit_0__ = ncensor;
        for (size_t i_0__ = 0; i_0__ < sid_c_limit_0__; ++i_0__) {
            sid_c[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("pid_c", "ncensor", ncensor);
        context__.validate_dims("data initialization", "pid_c", "int", context__.to_vec(ncensor));
        validate_non_negative_index("pid_c", "ncensor", ncensor);
        pid_c = std::vector<int>(ncensor,int(0));
        vals_i__ = context__.vals_i("pid_c");
        pos__ = 0;
        size_t pid_c_limit_0__ = ncensor;
        for (size_t i_0__ = 0; i_0__ < pid_c_limit_0__; ++i_0__) {
            pid_c[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("pred_c", "ncensor", ncensor);
        validate_non_negative_index("pred_c", "npred", npred);
        context__.validate_dims("data initialization", "pred_c", "matrix_d", context__.to_vec(ncensor,npred));
        validate_non_negative_index("pred_c", "ncensor", ncensor);
        validate_non_negative_index("pred_c", "npred", npred);
        pred_c = matrix_d(static_cast<Eigen::VectorXd::Index>(ncensor),static_cast<Eigen::VectorXd::Index>(npred));
        vals_r__ = context__.vals_r("pred_c");
        pos__ = 0;
        size_t pred_c_m_mat_lim__ = ncensor;
        size_t pred_c_n_mat_lim__ = npred;
        for (size_t n_mat__ = 0; n_mat__ < pred_c_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < pred_c_m_mat_lim__; ++m_mat__) {
                pred_c(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("pred_sub_c", "ncensor", ncensor);
        validate_non_negative_index("pred_sub_c", "npred_sub", npred_sub);
        context__.validate_dims("data initialization", "pred_sub_c", "matrix_d", context__.to_vec(ncensor,npred_sub));
        validate_non_negative_index("pred_sub_c", "ncensor", ncensor);
        validate_non_negative_index("pred_sub_c", "npred_sub", npred_sub);
        pred_sub_c = matrix_d(static_cast<Eigen::VectorXd::Index>(ncensor),static_cast<Eigen::VectorXd::Index>(npred_sub));
        vals_r__ = context__.vals_r("pred_sub_c");
        pos__ = 0;
        size_t pred_sub_c_m_mat_lim__ = ncensor;
        size_t pred_sub_c_n_mat_lim__ = npred_sub;
        for (size_t n_mat__ = 0; n_mat__ < pred_sub_c_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < pred_sub_c_m_mat_lim__; ++m_mat__) {
                pred_sub_c(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }

        // validate, data variables
        check_greater_or_equal(function__,"nobs",nobs,0);
        for (int k0__ = 0; k0__ < nobs; ++k0__) {
            check_greater_or_equal(function__,"sid[k0__]",sid[k0__],0);
        }
        for (int k0__ = 0; k0__ < nmiss; ++k0__) {
            check_greater_or_equal(function__,"sid_m[k0__]",sid_m[k0__],0);
        }
        for (int k0__ = 0; k0__ < nobs; ++k0__) {
            check_greater_or_equal(function__,"pid[k0__]",pid[k0__],0);
        }
        for (int k0__ = 0; k0__ < nmiss; ++k0__) {
            check_greater_or_equal(function__,"pid_m[k0__]",pid_m[k0__],0);
        }
        stan::math::check_corr_matrix(function__,"R",R);
        stan::math::check_cov_matrix(function__,"prec",prec);
        for (int k0__ = 0; k0__ < ncensor; ++k0__) {
            check_greater_or_equal(function__,"sid_c[k0__]",sid_c[k0__],0);
        }
        for (int k0__ = 0; k0__ < ncensor; ++k0__) {
            check_greater_or_equal(function__,"pid_c[k0__]",pid_c[k0__],0);
        }
        // initialize data variables
        validate_non_negative_index("T", "npred", npred);
        validate_non_negative_index("T", "npred", npred);
        T = matrix_d(static_cast<Eigen::VectorXd::Index>(npred),static_cast<Eigen::VectorXd::Index>(npred));
        stan::math::fill(T,DUMMY_VAR__);
        validate_non_negative_index("invprec", "npred", npred);
        validate_non_negative_index("invprec", "npred", npred);
        invprec = matrix_d(static_cast<Eigen::VectorXd::Index>(npred),static_cast<Eigen::VectorXd::Index>(npred));
        stan::math::fill(invprec,DUMMY_VAR__);

        try {
            current_statement_begin__ = 44;
            stan::math::assign(T, multiply(multiply(diag_matrix(Sigma_sd),R),diag_matrix(Sigma_sd)));
            current_statement_begin__ = 45;
            stan::math::assign(invprec, inverse(prec));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data
        stan::math::check_cov_matrix(function__,"T",T);
        stan::math::check_cov_matrix(function__,"invprec",invprec);

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        validate_non_negative_index("U_latent", "np", np);
        validate_non_negative_index("U_latent", "npred", npred);
        num_params_r__ += np * npred;
        validate_non_negative_index("g", "npred", npred);
        num_params_r__ += npred;
        validate_non_negative_index("pVAR", "npred", npred);
        num_params_r__ += ((npred * (npred - 1)) / 2 + npred);
        ++num_params_r__;
        validate_non_negative_index("alpha_latent", "npred_miss", npred_miss);
        num_params_r__ += npred_miss;
        validate_non_negative_index("alpha_mu", "npred_miss", npred_miss);
        num_params_r__ += npred_miss;
        validate_non_negative_index("alpha_theta", "npred_miss", npred_miss);
        num_params_r__ += npred_miss;
        ++num_params_r__;
        validate_non_negative_index("beta2_latent", "nsid", nsid);
        validate_non_negative_index("beta2_latent", "npred_sub", npred_sub);
        num_params_r__ += nsid * npred_sub;
        validate_non_negative_index("beta2_theta", "npred_sub", npred_sub);
        num_params_r__ += npred_sub;
        validate_non_negative_index("beta2_mu", "nsid", nsid);
        validate_non_negative_index("beta2_mu", "npred_sub", npred_sub);
        num_params_r__ += nsid * npred_sub;
        validate_non_negative_index("y_m_latent", "nmiss", nmiss);
        num_params_r__ += nmiss;
    }

    ~model_mlmc_code() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("U_latent")))
            throw std::runtime_error("variable U_latent missing");
        vals_r__ = context__.vals_r("U_latent");
        pos__ = 0U;
        validate_non_negative_index("U_latent", "np", np);
        validate_non_negative_index("U_latent", "npred", npred);
        context__.validate_dims("initialization", "U_latent", "matrix_d", context__.to_vec(np,npred));
        // generate_declaration U_latent
        matrix_d U_latent(static_cast<Eigen::VectorXd::Index>(np),static_cast<Eigen::VectorXd::Index>(npred));
        for (int j2__ = 0U; j2__ < npred; ++j2__)
            for (int j1__ = 0U; j1__ < np; ++j1__)
                U_latent(j1__,j2__) = vals_r__[pos__++];
        try {
            writer__.matrix_unconstrain(U_latent);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable U_latent: ") + e.what());
        }

        if (!(context__.contains_r("g")))
            throw std::runtime_error("variable g missing");
        vals_r__ = context__.vals_r("g");
        pos__ = 0U;
        validate_non_negative_index("g", "npred", npred);
        context__.validate_dims("initialization", "g", "row_vector_d", context__.to_vec(npred));
        // generate_declaration g
        row_vector_d g(static_cast<Eigen::VectorXd::Index>(npred));
        for (int j1__ = 0U; j1__ < npred; ++j1__)
            g(j1__) = vals_r__[pos__++];
        try {
            writer__.row_vector_unconstrain(g);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable g: ") + e.what());
        }

        if (!(context__.contains_r("pVAR")))
            throw std::runtime_error("variable pVAR missing");
        vals_r__ = context__.vals_r("pVAR");
        pos__ = 0U;
        validate_non_negative_index("pVAR", "npred", npred);
        validate_non_negative_index("pVAR", "npred", npred);
        context__.validate_dims("initialization", "pVAR", "matrix_d", context__.to_vec(npred,npred));
        // generate_declaration pVAR
        matrix_d pVAR(static_cast<Eigen::VectorXd::Index>(npred),static_cast<Eigen::VectorXd::Index>(npred));
        for (int j2__ = 0U; j2__ < npred; ++j2__)
            for (int j1__ = 0U; j1__ < npred; ++j1__)
                pVAR(j1__,j2__) = vals_r__[pos__++];
        try {
            writer__.cov_matrix_unconstrain(pVAR);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable pVAR: ") + e.what());
        }

        if (!(context__.contains_r("ita")))
            throw std::runtime_error("variable ita missing");
        vals_r__ = context__.vals_r("ita");
        pos__ = 0U;
        context__.validate_dims("initialization", "ita", "double", context__.to_vec());
        // generate_declaration ita
        double ita(0);
        ita = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,ita);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable ita: ") + e.what());
        }

        if (!(context__.contains_r("alpha_latent")))
            throw std::runtime_error("variable alpha_latent missing");
        vals_r__ = context__.vals_r("alpha_latent");
        pos__ = 0U;
        validate_non_negative_index("alpha_latent", "npred_miss", npred_miss);
        context__.validate_dims("initialization", "alpha_latent", "vector_d", context__.to_vec(npred_miss));
        // generate_declaration alpha_latent
        vector_d alpha_latent(static_cast<Eigen::VectorXd::Index>(npred_miss));
        for (int j1__ = 0U; j1__ < npred_miss; ++j1__)
            alpha_latent(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(alpha_latent);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha_latent: ") + e.what());
        }

        if (!(context__.contains_r("alpha_mu")))
            throw std::runtime_error("variable alpha_mu missing");
        vals_r__ = context__.vals_r("alpha_mu");
        pos__ = 0U;
        validate_non_negative_index("alpha_mu", "npred_miss", npred_miss);
        context__.validate_dims("initialization", "alpha_mu", "vector_d", context__.to_vec(npred_miss));
        // generate_declaration alpha_mu
        vector_d alpha_mu(static_cast<Eigen::VectorXd::Index>(npred_miss));
        for (int j1__ = 0U; j1__ < npred_miss; ++j1__)
            alpha_mu(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(alpha_mu);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha_mu: ") + e.what());
        }

        if (!(context__.contains_r("alpha_theta")))
            throw std::runtime_error("variable alpha_theta missing");
        vals_r__ = context__.vals_r("alpha_theta");
        pos__ = 0U;
        validate_non_negative_index("alpha_theta", "npred_miss", npred_miss);
        context__.validate_dims("initialization", "alpha_theta", "vector_d", context__.to_vec(npred_miss));
        // generate_declaration alpha_theta
        vector_d alpha_theta(static_cast<Eigen::VectorXd::Index>(npred_miss));
        for (int j1__ = 0U; j1__ < npred_miss; ++j1__)
            alpha_theta(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(alpha_theta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha_theta: ") + e.what());
        }

        if (!(context__.contains_r("alpha_response")))
            throw std::runtime_error("variable alpha_response missing");
        vals_r__ = context__.vals_r("alpha_response");
        pos__ = 0U;
        context__.validate_dims("initialization", "alpha_response", "double", context__.to_vec());
        // generate_declaration alpha_response
        double alpha_response(0);
        alpha_response = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(alpha_response);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha_response: ") + e.what());
        }

        if (!(context__.contains_r("beta2_latent")))
            throw std::runtime_error("variable beta2_latent missing");
        vals_r__ = context__.vals_r("beta2_latent");
        pos__ = 0U;
        validate_non_negative_index("beta2_latent", "nsid", nsid);
        validate_non_negative_index("beta2_latent", "npred_sub", npred_sub);
        context__.validate_dims("initialization", "beta2_latent", "matrix_d", context__.to_vec(nsid,npred_sub));
        // generate_declaration beta2_latent
        matrix_d beta2_latent(static_cast<Eigen::VectorXd::Index>(nsid),static_cast<Eigen::VectorXd::Index>(npred_sub));
        for (int j2__ = 0U; j2__ < npred_sub; ++j2__)
            for (int j1__ = 0U; j1__ < nsid; ++j1__)
                beta2_latent(j1__,j2__) = vals_r__[pos__++];
        try {
            writer__.matrix_unconstrain(beta2_latent);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta2_latent: ") + e.what());
        }

        if (!(context__.contains_r("beta2_theta")))
            throw std::runtime_error("variable beta2_theta missing");
        vals_r__ = context__.vals_r("beta2_theta");
        pos__ = 0U;
        validate_non_negative_index("beta2_theta", "npred_sub", npred_sub);
        context__.validate_dims("initialization", "beta2_theta", "row_vector_d", context__.to_vec(npred_sub));
        // generate_declaration beta2_theta
        row_vector_d beta2_theta(static_cast<Eigen::VectorXd::Index>(npred_sub));
        for (int j1__ = 0U; j1__ < npred_sub; ++j1__)
            beta2_theta(j1__) = vals_r__[pos__++];
        try {
            writer__.row_vector_unconstrain(beta2_theta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta2_theta: ") + e.what());
        }

        if (!(context__.contains_r("beta2_mu")))
            throw std::runtime_error("variable beta2_mu missing");
        vals_r__ = context__.vals_r("beta2_mu");
        pos__ = 0U;
        validate_non_negative_index("beta2_mu", "nsid", nsid);
        validate_non_negative_index("beta2_mu", "npred_sub", npred_sub);
        context__.validate_dims("initialization", "beta2_mu", "matrix_d", context__.to_vec(nsid,npred_sub));
        // generate_declaration beta2_mu
        matrix_d beta2_mu(static_cast<Eigen::VectorXd::Index>(nsid),static_cast<Eigen::VectorXd::Index>(npred_sub));
        for (int j2__ = 0U; j2__ < npred_sub; ++j2__)
            for (int j1__ = 0U; j1__ < nsid; ++j1__)
                beta2_mu(j1__,j2__) = vals_r__[pos__++];
        try {
            writer__.matrix_unconstrain(beta2_mu);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta2_mu: ") + e.what());
        }

        if (!(context__.contains_r("y_m_latent")))
            throw std::runtime_error("variable y_m_latent missing");
        vals_r__ = context__.vals_r("y_m_latent");
        pos__ = 0U;
        validate_non_negative_index("y_m_latent", "nmiss", nmiss);
        context__.validate_dims("initialization", "y_m_latent", "double", context__.to_vec(nmiss));
        // generate_declaration y_m_latent
        std::vector<double> y_m_latent(nmiss,double(0));
        for (int i0__ = 0U; i0__ < nmiss; ++i0__)
            y_m_latent[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < nmiss; ++i0__)
            try {
            writer__.scalar_unconstrain(y_m_latent[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable y_m_latent: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  U_latent;
        (void) U_latent;  // dummy to suppress unused var warning
        if (jacobian__)
            U_latent = in__.matrix_constrain(np,npred,lp__);
        else
            U_latent = in__.matrix_constrain(np,npred);

        Eigen::Matrix<T__,1,Eigen::Dynamic>  g;
        (void) g;  // dummy to suppress unused var warning
        if (jacobian__)
            g = in__.row_vector_constrain(npred,lp__);
        else
            g = in__.row_vector_constrain(npred);

        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  pVAR;
        (void) pVAR;  // dummy to suppress unused var warning
        if (jacobian__)
            pVAR = in__.cov_matrix_constrain(npred,lp__);
        else
            pVAR = in__.cov_matrix_constrain(npred);

        T__ ita;
        (void) ita;  // dummy to suppress unused var warning
        if (jacobian__)
            ita = in__.scalar_lb_constrain(0,lp__);
        else
            ita = in__.scalar_lb_constrain(0);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  alpha_latent;
        (void) alpha_latent;  // dummy to suppress unused var warning
        if (jacobian__)
            alpha_latent = in__.vector_constrain(npred_miss,lp__);
        else
            alpha_latent = in__.vector_constrain(npred_miss);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  alpha_mu;
        (void) alpha_mu;  // dummy to suppress unused var warning
        if (jacobian__)
            alpha_mu = in__.vector_constrain(npred_miss,lp__);
        else
            alpha_mu = in__.vector_constrain(npred_miss);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  alpha_theta;
        (void) alpha_theta;  // dummy to suppress unused var warning
        if (jacobian__)
            alpha_theta = in__.vector_constrain(npred_miss,lp__);
        else
            alpha_theta = in__.vector_constrain(npred_miss);

        T__ alpha_response;
        (void) alpha_response;  // dummy to suppress unused var warning
        if (jacobian__)
            alpha_response = in__.scalar_constrain(lp__);
        else
            alpha_response = in__.scalar_constrain();

        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  beta2_latent;
        (void) beta2_latent;  // dummy to suppress unused var warning
        if (jacobian__)
            beta2_latent = in__.matrix_constrain(nsid,npred_sub,lp__);
        else
            beta2_latent = in__.matrix_constrain(nsid,npred_sub);

        Eigen::Matrix<T__,1,Eigen::Dynamic>  beta2_theta;
        (void) beta2_theta;  // dummy to suppress unused var warning
        if (jacobian__)
            beta2_theta = in__.row_vector_constrain(npred_sub,lp__);
        else
            beta2_theta = in__.row_vector_constrain(npred_sub);

        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  beta2_mu;
        (void) beta2_mu;  // dummy to suppress unused var warning
        if (jacobian__)
            beta2_mu = in__.matrix_constrain(nsid,npred_sub,lp__);
        else
            beta2_mu = in__.matrix_constrain(nsid,npred_sub);

        vector<T__> y_m_latent;
        size_t dim_y_m_latent_0__ = nmiss;
        y_m_latent.reserve(dim_y_m_latent_0__);
        for (size_t k_0__ = 0; k_0__ < dim_y_m_latent_0__; ++k_0__) {
            if (jacobian__)
                y_m_latent.push_back(in__.scalar_constrain(lp__));
            else
                y_m_latent.push_back(in__.scalar_constrain());
        }


        // transformed parameters
        validate_non_negative_index("U", "np", np);
        validate_non_negative_index("U", "npred", npred);
        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  U(static_cast<Eigen::VectorXd::Index>(np),static_cast<Eigen::VectorXd::Index>(npred));
        (void) U;  // dummy to suppress unused var warning

        stan::math::initialize(U, DUMMY_VAR__);
        stan::math::fill(U,DUMMY_VAR__);
        validate_non_negative_index("beta2", "nsid", nsid);
        validate_non_negative_index("beta2", "npred_sub", npred_sub);
        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  beta2(static_cast<Eigen::VectorXd::Index>(nsid),static_cast<Eigen::VectorXd::Index>(npred_sub));
        (void) beta2;  // dummy to suppress unused var warning

        stan::math::initialize(beta2, DUMMY_VAR__);
        stan::math::fill(beta2,DUMMY_VAR__);
        validate_non_negative_index("alpha", "npred_miss", npred_miss);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  alpha(static_cast<Eigen::VectorXd::Index>(npred_miss));
        (void) alpha;  // dummy to suppress unused var warning

        stan::math::initialize(alpha, DUMMY_VAR__);
        stan::math::fill(alpha,DUMMY_VAR__);
        validate_non_negative_index("mu_m", "nmiss", nmiss);
        vector<T__> mu_m(nmiss);
        stan::math::initialize(mu_m, DUMMY_VAR__);
        stan::math::fill(mu_m,DUMMY_VAR__);
        validate_non_negative_index("mu", "nobs", nobs);
        vector<T__> mu(nobs);
        stan::math::initialize(mu, DUMMY_VAR__);
        stan::math::fill(mu,DUMMY_VAR__);
        validate_non_negative_index("mu_c", "ncensor", ncensor);
        vector<T__> mu_c(ncensor);
        stan::math::initialize(mu_c, DUMMY_VAR__);
        stan::math::fill(mu_c,DUMMY_VAR__);
        validate_non_negative_index("y_m", "nmiss", nmiss);
        vector<T__> y_m(nmiss);
        stan::math::initialize(y_m, DUMMY_VAR__);
        stan::math::fill(y_m,DUMMY_VAR__);
        validate_non_negative_index("pmiss", "nobs", nobs);
        vector<T__> pmiss(nobs);
        stan::math::initialize(pmiss, DUMMY_VAR__);
        stan::math::fill(pmiss,DUMMY_VAR__);
        validate_non_negative_index("pmiss_m", "nmiss", nmiss);
        vector<T__> pmiss_m(nmiss);
        stan::math::initialize(pmiss_m, DUMMY_VAR__);
        stan::math::fill(pmiss_m,DUMMY_VAR__);


        try {
            current_statement_begin__ = 77;
            for (int sub = 1; sub <= nsid; ++sub) {
                current_statement_begin__ = 78;
                stan::math::assign(get_base1_lhs(beta2,sub,"beta2",1), add(get_base1(beta2_mu,sub,"beta2_mu",1),dot_product(beta2_theta,get_base1(beta2_latent,sub,"beta2_latent",1))));
            }
            current_statement_begin__ = 80;
            for (int prot = 1; prot <= np; ++prot) {
                current_statement_begin__ = 81;
                stan::math::assign(get_base1_lhs(U,prot,"U",1), add(g,multiply(get_base1(U_latent,prot,"U_latent",1),pVAR)));
            }
            current_statement_begin__ = 83;
            stan::math::assign(alpha, add(alpha_mu,dot_product(alpha_theta,alpha_latent)));
            current_statement_begin__ = 85;
            for (int pep = 1; pep <= nobs; ++pep) {

                current_statement_begin__ = 86;
                stan::math::assign(get_base1_lhs(mu,pep,"mu",1), (dot_product(get_base1(pred_sub,pep,"pred_sub",1),get_base1(beta2,get_base1(sid,pep,"sid",1),"beta2",1)) + dot_product(get_base1(pred,pep,"pred",1),get_base1(U,get_base1(pid,pep,"pid",1),"U",1))));
                current_statement_begin__ = 87;
                if (as_bool(logical_eq(respond_dep,1))) {
                    current_statement_begin__ = 87;
                    stan::math::assign(get_base1_lhs(pmiss,pep,"pmiss",1), inv_logit((dot_product(alpha,get_base1(pred_miss,pep,"pred_miss",1)) + (alpha_response * get_base1(mu,pep,"mu",1)))));
                } else {
                    current_statement_begin__ = 88;
                    stan::math::assign(get_base1_lhs(pmiss,pep,"pmiss",1), inv_logit(dot_product(alpha,get_base1(pred_miss,pep,"pred_miss",1))));
                }
                current_statement_begin__ = 89;
                if (as_bool(logical_eq(get_base1(pmiss,pep,"pmiss",1),0))) {
                    current_statement_begin__ = 89;
                    stan::math::assign(get_base1_lhs(pmiss,pep,"pmiss",1), 0.001);
                }
                current_statement_begin__ = 90;
                if (as_bool(logical_eq(get_base1(pmiss,pep,"pmiss",1),1))) {
                    current_statement_begin__ = 90;
                    stan::math::assign(get_base1_lhs(pmiss,pep,"pmiss",1), 0.999);
                }
            }
            current_statement_begin__ = 93;
            for (int pep2 = 1; pep2 <= nmiss; ++pep2) {

                current_statement_begin__ = 94;
                stan::math::assign(get_base1_lhs(mu_m,pep2,"mu_m",1), (dot_product(get_base1(beta2,get_base1(sid_m,pep2,"sid_m",1),"beta2",1),get_base1(pred_sub_m,pep2,"pred_sub_m",1)) + dot_product(get_base1(pred_m,pep2,"pred_m",1),get_base1(U,get_base1(pid_m,pep2,"pid_m",1),"U",1))));
                current_statement_begin__ = 95;
                stan::math::assign(get_base1_lhs(y_m,pep2,"y_m",1), (get_base1(mu_m,pep2,"mu_m",1) + (get_base1(y_m_latent,pep2,"y_m_latent",1) * ita)));
                current_statement_begin__ = 96;
                if (as_bool(logical_eq(respond_dep,1))) {
                    current_statement_begin__ = 96;
                    stan::math::assign(get_base1_lhs(pmiss_m,pep2,"pmiss_m",1), inv_logit((dot_product(alpha,get_base1(pred_miss_m,pep2,"pred_miss_m",1)) + (alpha_response * get_base1(mu_m,pep2,"mu_m",1)))));
                } else {
                    current_statement_begin__ = 97;
                    stan::math::assign(get_base1_lhs(pmiss_m,pep2,"pmiss_m",1), inv_logit(dot_product(alpha,get_base1(pred_miss,pep2,"pred_miss",1))));
                }
                current_statement_begin__ = 98;
                if (as_bool(logical_eq(get_base1(pmiss_m,pep2,"pmiss_m",1),0))) {
                    current_statement_begin__ = 98;
                    stan::math::assign(get_base1_lhs(pmiss_m,pep2,"pmiss_m",1), 0.001);
                }
                current_statement_begin__ = 99;
                if (as_bool(logical_eq(get_base1(pmiss_m,pep2,"pmiss_m",1),1))) {
                    current_statement_begin__ = 99;
                    stan::math::assign(get_base1_lhs(pmiss_m,pep2,"pmiss_m",1), 0.999);
                }
            }
            current_statement_begin__ = 101;
            for (int pep3 = 1; pep3 <= ncensor; ++pep3) {

                current_statement_begin__ = 102;
                stan::math::assign(get_base1_lhs(mu_c,pep3,"mu_c",1), (dot_product(get_base1(beta2,get_base1(sid_c,pep3,"sid_c",1),"beta2",1),get_base1(pred_sub_c,pep3,"pred_sub_c",1)) + dot_product(get_base1(U,get_base1(pid_c,pep3,"pid_c",1),"U",1),get_base1(pred_c,pep3,"pred_c",1))));
                current_statement_begin__ = 103;
                if (as_bool(logical_gt(get_base1(mu_c,pep3,"mu_c",1),censor_lim))) {
                    current_statement_begin__ = 103;
                    stan::math::assign(get_base1_lhs(mu_c,pep3,"mu_c",1), censor_lim);
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < np; ++i0__) {
            for (int i1__ = 0; i1__ < npred; ++i1__) {
                if (stan::math::is_uninitialized(U(i0__,i1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: U" << '[' << i0__ << ']' << '[' << i1__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
        }
        for (int i0__ = 0; i0__ < nsid; ++i0__) {
            for (int i1__ = 0; i1__ < npred_sub; ++i1__) {
                if (stan::math::is_uninitialized(beta2(i0__,i1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta2" << '[' << i0__ << ']' << '[' << i1__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
        }
        for (int i0__ = 0; i0__ < npred_miss; ++i0__) {
            if (stan::math::is_uninitialized(alpha(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: alpha" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < nmiss; ++i0__) {
            if (stan::math::is_uninitialized(mu_m[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: mu_m" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < nobs; ++i0__) {
            if (stan::math::is_uninitialized(mu[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: mu" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < ncensor; ++i0__) {
            if (stan::math::is_uninitialized(mu_c[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: mu_c" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < nmiss; ++i0__) {
            if (stan::math::is_uninitialized(y_m[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: y_m" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < nobs; ++i0__) {
            if (stan::math::is_uninitialized(pmiss[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: pmiss" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < nmiss; ++i0__) {
            if (stan::math::is_uninitialized(pmiss_m[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: pmiss_m" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        for (int k0__ = 0; k0__ < nobs; ++k0__) {
            check_greater_or_equal(function__,"pmiss[k0__]",pmiss[k0__],0);
            check_less_or_equal(function__,"pmiss[k0__]",pmiss[k0__],1);
        }
        for (int k0__ = 0; k0__ < nmiss; ++k0__) {
            check_greater_or_equal(function__,"pmiss_m[k0__]",pmiss_m[k0__],0);
            check_less_or_equal(function__,"pmiss_m[k0__]",pmiss_m[k0__],1);
        }

        // model body
        try {

            current_statement_begin__ = 109;
            for (int sub = 1; sub <= nsid; ++sub) {

                current_statement_begin__ = 110;
                lp_accum__.add(normal_log<propto__>(get_base1(beta2_latent,sub,"beta2_latent",1), 0, 1));
                current_statement_begin__ = 111;
                lp_accum__.add(normal_log<propto__>(get_base1(beta2_mu,sub,"beta2_mu",1), 0, 1));
            }
            current_statement_begin__ = 112;
            lp_accum__.add(gamma_log<propto__>(beta2_theta, 1, 1));
            current_statement_begin__ = 113;
            lp_accum__.add(multi_normal_log<propto__>(g, mn, T));
            current_statement_begin__ = 114;
            lp_accum__.add(inv_wishart_log<propto__>(pVAR, npred, invprec));
            current_statement_begin__ = 116;
            for (int prot = 1; prot <= np; ++prot) {
                current_statement_begin__ = 117;
                lp_accum__.add(multi_normal_log<propto__>(get_base1(U_latent,prot,"U_latent",1), mn, R));
            }
            current_statement_begin__ = 119;
            lp_accum__.add(gamma_log<propto__>(ita, 1, 1));
            current_statement_begin__ = 120;
            lp_accum__.add(normal_log<propto__>(y, mu, ita));
            current_statement_begin__ = 122;
            lp_accum__.add(normal_log<propto__>(alpha_latent, 0, 1));
            current_statement_begin__ = 123;
            lp_accum__.add(normal_log<propto__>(alpha_mu, 0, 1));
            current_statement_begin__ = 124;
            lp_accum__.add(gamma_log<propto__>(alpha_theta, 1, 1));
            current_statement_begin__ = 125;
            for (int pep = 1; pep <= nobs; ++pep) {
                current_statement_begin__ = 126;
                lp_accum__.add(bernoulli_log<propto__>(get_base1(miss_obs,pep,"miss_obs",1), get_base1(pmiss,pep,"pmiss",1)));
            }
            current_statement_begin__ = 128;
            for (int pep2 = 1; pep2 <= nmiss; ++pep2) {

                current_statement_begin__ = 129;
                lp_accum__.add(bernoulli_log<propto__>(get_base1(miss_m,pep2,"miss_m",1), get_base1(pmiss_m,pep2,"pmiss_m",1)));
                current_statement_begin__ = 130;
                lp_accum__.add(normal_log<propto__>(get_base1(y_m_latent,pep2,"y_m_latent",1), 0, 1));
            }
            current_statement_begin__ = 132;
            if (as_bool(logical_gt(ncensor,0))) {

                current_statement_begin__ = 133;
                for (int pep = 1; pep <= ncensor; ++pep) {
                    current_statement_begin__ = 134;
                    lp_accum__.add(log((Phi(((censor_lim - get_base1(mu_c,pep,"mu_c",1)) / ita)) + 0.001)));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("U_latent");
        names__.push_back("g");
        names__.push_back("pVAR");
        names__.push_back("ita");
        names__.push_back("alpha_latent");
        names__.push_back("alpha_mu");
        names__.push_back("alpha_theta");
        names__.push_back("alpha_response");
        names__.push_back("beta2_latent");
        names__.push_back("beta2_theta");
        names__.push_back("beta2_mu");
        names__.push_back("y_m_latent");
        names__.push_back("U");
        names__.push_back("beta2");
        names__.push_back("alpha");
        names__.push_back("mu_m");
        names__.push_back("mu");
        names__.push_back("mu_c");
        names__.push_back("y_m");
        names__.push_back("pmiss");
        names__.push_back("pmiss_m");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(np);
        dims__.push_back(npred);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(npred);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(npred);
        dims__.push_back(npred);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(npred_miss);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(npred_miss);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(npred_miss);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nsid);
        dims__.push_back(npred_sub);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(npred_sub);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nsid);
        dims__.push_back(npred_sub);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nmiss);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(np);
        dims__.push_back(npred);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nsid);
        dims__.push_back(npred_sub);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(npred_miss);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nmiss);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nobs);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ncensor);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nmiss);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nobs);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nmiss);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_mlmc_code_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        matrix_d U_latent = in__.matrix_constrain(np,npred);
        row_vector_d g = in__.row_vector_constrain(npred);
        matrix_d pVAR = in__.cov_matrix_constrain(npred);
        double ita = in__.scalar_lb_constrain(0);
        vector_d alpha_latent = in__.vector_constrain(npred_miss);
        vector_d alpha_mu = in__.vector_constrain(npred_miss);
        vector_d alpha_theta = in__.vector_constrain(npred_miss);
        double alpha_response = in__.scalar_constrain();
        matrix_d beta2_latent = in__.matrix_constrain(nsid,npred_sub);
        row_vector_d beta2_theta = in__.row_vector_constrain(npred_sub);
        matrix_d beta2_mu = in__.matrix_constrain(nsid,npred_sub);
        vector<double> y_m_latent;
        size_t dim_y_m_latent_0__ = nmiss;
        for (size_t k_0__ = 0; k_0__ < dim_y_m_latent_0__; ++k_0__) {
            y_m_latent.push_back(in__.scalar_constrain());
        }
        for (int k_1__ = 0; k_1__ < npred; ++k_1__) {
            for (int k_0__ = 0; k_0__ < np; ++k_0__) {
                vars__.push_back(U_latent(k_0__, k_1__));
            }
        }
        for (int k_0__ = 0; k_0__ < npred; ++k_0__) {
            vars__.push_back(g[k_0__]);
        }
        for (int k_1__ = 0; k_1__ < npred; ++k_1__) {
            for (int k_0__ = 0; k_0__ < npred; ++k_0__) {
                vars__.push_back(pVAR(k_0__, k_1__));
            }
        }
        vars__.push_back(ita);
        for (int k_0__ = 0; k_0__ < npred_miss; ++k_0__) {
            vars__.push_back(alpha_latent[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < npred_miss; ++k_0__) {
            vars__.push_back(alpha_mu[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < npred_miss; ++k_0__) {
            vars__.push_back(alpha_theta[k_0__]);
        }
        vars__.push_back(alpha_response);
        for (int k_1__ = 0; k_1__ < npred_sub; ++k_1__) {
            for (int k_0__ = 0; k_0__ < nsid; ++k_0__) {
                vars__.push_back(beta2_latent(k_0__, k_1__));
            }
        }
        for (int k_0__ = 0; k_0__ < npred_sub; ++k_0__) {
            vars__.push_back(beta2_theta[k_0__]);
        }
        for (int k_1__ = 0; k_1__ < npred_sub; ++k_1__) {
            for (int k_0__ = 0; k_0__ < nsid; ++k_0__) {
                vars__.push_back(beta2_mu(k_0__, k_1__));
            }
        }
        for (int k_0__ = 0; k_0__ < nmiss; ++k_0__) {
            vars__.push_back(y_m_latent[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        validate_non_negative_index("U", "np", np);
        validate_non_negative_index("U", "npred", npred);
        matrix_d U(static_cast<Eigen::VectorXd::Index>(np),static_cast<Eigen::VectorXd::Index>(npred));
        (void) U;  // dummy to suppress unused var warning

        stan::math::initialize(U, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(U,DUMMY_VAR__);
        validate_non_negative_index("beta2", "nsid", nsid);
        validate_non_negative_index("beta2", "npred_sub", npred_sub);
        matrix_d beta2(static_cast<Eigen::VectorXd::Index>(nsid),static_cast<Eigen::VectorXd::Index>(npred_sub));
        (void) beta2;  // dummy to suppress unused var warning

        stan::math::initialize(beta2, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(beta2,DUMMY_VAR__);
        validate_non_negative_index("alpha", "npred_miss", npred_miss);
        vector_d alpha(static_cast<Eigen::VectorXd::Index>(npred_miss));
        (void) alpha;  // dummy to suppress unused var warning

        stan::math::initialize(alpha, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(alpha,DUMMY_VAR__);
        validate_non_negative_index("mu_m", "nmiss", nmiss);
        vector<double> mu_m(nmiss, 0.0);
        stan::math::initialize(mu_m, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_m,DUMMY_VAR__);
        validate_non_negative_index("mu", "nobs", nobs);
        vector<double> mu(nobs, 0.0);
        stan::math::initialize(mu, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu,DUMMY_VAR__);
        validate_non_negative_index("mu_c", "ncensor", ncensor);
        vector<double> mu_c(ncensor, 0.0);
        stan::math::initialize(mu_c, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_c,DUMMY_VAR__);
        validate_non_negative_index("y_m", "nmiss", nmiss);
        vector<double> y_m(nmiss, 0.0);
        stan::math::initialize(y_m, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(y_m,DUMMY_VAR__);
        validate_non_negative_index("pmiss", "nobs", nobs);
        vector<double> pmiss(nobs, 0.0);
        stan::math::initialize(pmiss, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pmiss,DUMMY_VAR__);
        validate_non_negative_index("pmiss_m", "nmiss", nmiss);
        vector<double> pmiss_m(nmiss, 0.0);
        stan::math::initialize(pmiss_m, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pmiss_m,DUMMY_VAR__);


        try {
            current_statement_begin__ = 77;
            for (int sub = 1; sub <= nsid; ++sub) {
                current_statement_begin__ = 78;
                stan::math::assign(get_base1_lhs(beta2,sub,"beta2",1), add(get_base1(beta2_mu,sub,"beta2_mu",1),dot_product(beta2_theta,get_base1(beta2_latent,sub,"beta2_latent",1))));
            }
            current_statement_begin__ = 80;
            for (int prot = 1; prot <= np; ++prot) {
                current_statement_begin__ = 81;
                stan::math::assign(get_base1_lhs(U,prot,"U",1), add(g,multiply(get_base1(U_latent,prot,"U_latent",1),pVAR)));
            }
            current_statement_begin__ = 83;
            stan::math::assign(alpha, add(alpha_mu,dot_product(alpha_theta,alpha_latent)));
            current_statement_begin__ = 85;
            for (int pep = 1; pep <= nobs; ++pep) {

                current_statement_begin__ = 86;
                stan::math::assign(get_base1_lhs(mu,pep,"mu",1), (dot_product(get_base1(pred_sub,pep,"pred_sub",1),get_base1(beta2,get_base1(sid,pep,"sid",1),"beta2",1)) + dot_product(get_base1(pred,pep,"pred",1),get_base1(U,get_base1(pid,pep,"pid",1),"U",1))));
                current_statement_begin__ = 87;
                if (as_bool(logical_eq(respond_dep,1))) {
                    current_statement_begin__ = 87;
                    stan::math::assign(get_base1_lhs(pmiss,pep,"pmiss",1), inv_logit((dot_product(alpha,get_base1(pred_miss,pep,"pred_miss",1)) + (alpha_response * get_base1(mu,pep,"mu",1)))));
                } else {
                    current_statement_begin__ = 88;
                    stan::math::assign(get_base1_lhs(pmiss,pep,"pmiss",1), inv_logit(dot_product(alpha,get_base1(pred_miss,pep,"pred_miss",1))));
                }
                current_statement_begin__ = 89;
                if (as_bool(logical_eq(get_base1(pmiss,pep,"pmiss",1),0))) {
                    current_statement_begin__ = 89;
                    stan::math::assign(get_base1_lhs(pmiss,pep,"pmiss",1), 0.001);
                }
                current_statement_begin__ = 90;
                if (as_bool(logical_eq(get_base1(pmiss,pep,"pmiss",1),1))) {
                    current_statement_begin__ = 90;
                    stan::math::assign(get_base1_lhs(pmiss,pep,"pmiss",1), 0.999);
                }
            }
            current_statement_begin__ = 93;
            for (int pep2 = 1; pep2 <= nmiss; ++pep2) {

                current_statement_begin__ = 94;
                stan::math::assign(get_base1_lhs(mu_m,pep2,"mu_m",1), (dot_product(get_base1(beta2,get_base1(sid_m,pep2,"sid_m",1),"beta2",1),get_base1(pred_sub_m,pep2,"pred_sub_m",1)) + dot_product(get_base1(pred_m,pep2,"pred_m",1),get_base1(U,get_base1(pid_m,pep2,"pid_m",1),"U",1))));
                current_statement_begin__ = 95;
                stan::math::assign(get_base1_lhs(y_m,pep2,"y_m",1), (get_base1(mu_m,pep2,"mu_m",1) + (get_base1(y_m_latent,pep2,"y_m_latent",1) * ita)));
                current_statement_begin__ = 96;
                if (as_bool(logical_eq(respond_dep,1))) {
                    current_statement_begin__ = 96;
                    stan::math::assign(get_base1_lhs(pmiss_m,pep2,"pmiss_m",1), inv_logit((dot_product(alpha,get_base1(pred_miss_m,pep2,"pred_miss_m",1)) + (alpha_response * get_base1(mu_m,pep2,"mu_m",1)))));
                } else {
                    current_statement_begin__ = 97;
                    stan::math::assign(get_base1_lhs(pmiss_m,pep2,"pmiss_m",1), inv_logit(dot_product(alpha,get_base1(pred_miss,pep2,"pred_miss",1))));
                }
                current_statement_begin__ = 98;
                if (as_bool(logical_eq(get_base1(pmiss_m,pep2,"pmiss_m",1),0))) {
                    current_statement_begin__ = 98;
                    stan::math::assign(get_base1_lhs(pmiss_m,pep2,"pmiss_m",1), 0.001);
                }
                current_statement_begin__ = 99;
                if (as_bool(logical_eq(get_base1(pmiss_m,pep2,"pmiss_m",1),1))) {
                    current_statement_begin__ = 99;
                    stan::math::assign(get_base1_lhs(pmiss_m,pep2,"pmiss_m",1), 0.999);
                }
            }
            current_statement_begin__ = 101;
            for (int pep3 = 1; pep3 <= ncensor; ++pep3) {

                current_statement_begin__ = 102;
                stan::math::assign(get_base1_lhs(mu_c,pep3,"mu_c",1), (dot_product(get_base1(beta2,get_base1(sid_c,pep3,"sid_c",1),"beta2",1),get_base1(pred_sub_c,pep3,"pred_sub_c",1)) + dot_product(get_base1(U,get_base1(pid_c,pep3,"pid_c",1),"U",1),get_base1(pred_c,pep3,"pred_c",1))));
                current_statement_begin__ = 103;
                if (as_bool(logical_gt(get_base1(mu_c,pep3,"mu_c",1),censor_lim))) {
                    current_statement_begin__ = 103;
                    stan::math::assign(get_base1_lhs(mu_c,pep3,"mu_c",1), censor_lim);
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int k0__ = 0; k0__ < nobs; ++k0__) {
            check_greater_or_equal(function__,"pmiss[k0__]",pmiss[k0__],0);
            check_less_or_equal(function__,"pmiss[k0__]",pmiss[k0__],1);
        }
        for (int k0__ = 0; k0__ < nmiss; ++k0__) {
            check_greater_or_equal(function__,"pmiss_m[k0__]",pmiss_m[k0__],0);
            check_less_or_equal(function__,"pmiss_m[k0__]",pmiss_m[k0__],1);
        }

        // write transformed parameters
        for (int k_1__ = 0; k_1__ < npred; ++k_1__) {
            for (int k_0__ = 0; k_0__ < np; ++k_0__) {
                vars__.push_back(U(k_0__, k_1__));
            }
        }
        for (int k_1__ = 0; k_1__ < npred_sub; ++k_1__) {
            for (int k_0__ = 0; k_0__ < nsid; ++k_0__) {
                vars__.push_back(beta2(k_0__, k_1__));
            }
        }
        for (int k_0__ = 0; k_0__ < npred_miss; ++k_0__) {
            vars__.push_back(alpha[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nmiss; ++k_0__) {
            vars__.push_back(mu_m[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nobs; ++k_0__) {
            vars__.push_back(mu[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < ncensor; ++k_0__) {
            vars__.push_back(mu_c[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nmiss; ++k_0__) {
            vars__.push_back(y_m[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nobs; ++k_0__) {
            vars__.push_back(pmiss[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nmiss; ++k_0__) {
            vars__.push_back(pmiss_m[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities


        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_mlmc_code";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_1__ = 1; k_1__ <= npred; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= np; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "U_latent" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= npred; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "g" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= npred; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= npred; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "pVAR" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "ita";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= npred_miss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_latent" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= npred_miss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= npred_miss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_theta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha_response";
        param_names__.push_back(param_name_stream__.str());
        for (int k_1__ = 1; k_1__ <= npred_sub; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nsid; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta2_latent" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= npred_sub; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta2_theta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= npred_sub; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nsid; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta2_mu" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= nmiss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_m_latent" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= npred; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= np; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "U" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= npred_sub; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nsid; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta2" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= npred_miss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nmiss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_m" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nobs; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= ncensor; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_c" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nmiss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_m" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nobs; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pmiss" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nmiss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pmiss_m" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_1__ = 1; k_1__ <= npred; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= np; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "U_latent" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= npred; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "g" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (npred + ((npred * (npred - 1)) / 2)); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pVAR" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "ita";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= npred_miss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_latent" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= npred_miss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= npred_miss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_theta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha_response";
        param_names__.push_back(param_name_stream__.str());
        for (int k_1__ = 1; k_1__ <= npred_sub; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nsid; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta2_latent" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= npred_sub; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta2_theta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= npred_sub; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nsid; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta2_mu" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= nmiss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_m_latent" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= npred; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= np; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "U" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= npred_sub; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nsid; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta2" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= npred_miss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nmiss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_m" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nobs; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= ncensor; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_c" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nmiss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_m" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nobs; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pmiss" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nmiss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pmiss_m" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }

}; // model

}




// Code generated by Stan version 2.16.0

#include <stan/model/model_header.hpp>

namespace model_mmlm_code_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_mmlm_code");
    reader.add_event(129, 129, "end", "model_mmlm_code");
    return reader;
}

class model_mmlm_code : public prob_grad {
private:
    int nobs;
    int nmiss;
    int npred;
    int npred_miss;
    int npred_sub;
    int nsid;
    int np;
    int respond_dep;
    vector<int> sid;
    vector<int> sid_m;
    vector<int> pid;
    vector<int> pid_m;
    matrix_d pred;
    matrix_d pred_m;
    matrix_d pred_miss;
    matrix_d pred_miss_m;
    matrix_d pred_sub;
    matrix_d pred_sub_m;
    vector<double> y;
    vector<int> miss_m;
    vector<int> miss_obs;
    matrix_d R;
    vector_d Sigma_sd;
    matrix_d prec;
    vector_d mn;
    matrix_d T;
    matrix_d invprec;
public:
    model_mmlm_code(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_mmlm_code(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_mmlm_code_namespace::model_mmlm_code";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "nobs", "int", context__.to_vec());
        nobs = int(0);
        vals_i__ = context__.vals_i("nobs");
        pos__ = 0;
        nobs = vals_i__[pos__++];
        context__.validate_dims("data initialization", "nmiss", "int", context__.to_vec());
        nmiss = int(0);
        vals_i__ = context__.vals_i("nmiss");
        pos__ = 0;
        nmiss = vals_i__[pos__++];
        context__.validate_dims("data initialization", "npred", "int", context__.to_vec());
        npred = int(0);
        vals_i__ = context__.vals_i("npred");
        pos__ = 0;
        npred = vals_i__[pos__++];
        context__.validate_dims("data initialization", "npred_miss", "int", context__.to_vec());
        npred_miss = int(0);
        vals_i__ = context__.vals_i("npred_miss");
        pos__ = 0;
        npred_miss = vals_i__[pos__++];
        context__.validate_dims("data initialization", "npred_sub", "int", context__.to_vec());
        npred_sub = int(0);
        vals_i__ = context__.vals_i("npred_sub");
        pos__ = 0;
        npred_sub = vals_i__[pos__++];
        context__.validate_dims("data initialization", "nsid", "int", context__.to_vec());
        nsid = int(0);
        vals_i__ = context__.vals_i("nsid");
        pos__ = 0;
        nsid = vals_i__[pos__++];
        context__.validate_dims("data initialization", "np", "int", context__.to_vec());
        np = int(0);
        vals_i__ = context__.vals_i("np");
        pos__ = 0;
        np = vals_i__[pos__++];
        context__.validate_dims("data initialization", "respond_dep", "int", context__.to_vec());
        respond_dep = int(0);
        vals_i__ = context__.vals_i("respond_dep");
        pos__ = 0;
        respond_dep = vals_i__[pos__++];
        validate_non_negative_index("sid", "nobs", nobs);
        context__.validate_dims("data initialization", "sid", "int", context__.to_vec(nobs));
        validate_non_negative_index("sid", "nobs", nobs);
        sid = std::vector<int>(nobs,int(0));
        vals_i__ = context__.vals_i("sid");
        pos__ = 0;
        size_t sid_limit_0__ = nobs;
        for (size_t i_0__ = 0; i_0__ < sid_limit_0__; ++i_0__) {
            sid[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("sid_m", "nmiss", nmiss);
        context__.validate_dims("data initialization", "sid_m", "int", context__.to_vec(nmiss));
        validate_non_negative_index("sid_m", "nmiss", nmiss);
        sid_m = std::vector<int>(nmiss,int(0));
        vals_i__ = context__.vals_i("sid_m");
        pos__ = 0;
        size_t sid_m_limit_0__ = nmiss;
        for (size_t i_0__ = 0; i_0__ < sid_m_limit_0__; ++i_0__) {
            sid_m[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("pid", "nobs", nobs);
        context__.validate_dims("data initialization", "pid", "int", context__.to_vec(nobs));
        validate_non_negative_index("pid", "nobs", nobs);
        pid = std::vector<int>(nobs,int(0));
        vals_i__ = context__.vals_i("pid");
        pos__ = 0;
        size_t pid_limit_0__ = nobs;
        for (size_t i_0__ = 0; i_0__ < pid_limit_0__; ++i_0__) {
            pid[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("pid_m", "nmiss", nmiss);
        context__.validate_dims("data initialization", "pid_m", "int", context__.to_vec(nmiss));
        validate_non_negative_index("pid_m", "nmiss", nmiss);
        pid_m = std::vector<int>(nmiss,int(0));
        vals_i__ = context__.vals_i("pid_m");
        pos__ = 0;
        size_t pid_m_limit_0__ = nmiss;
        for (size_t i_0__ = 0; i_0__ < pid_m_limit_0__; ++i_0__) {
            pid_m[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("pred", "nobs", nobs);
        validate_non_negative_index("pred", "npred", npred);
        context__.validate_dims("data initialization", "pred", "matrix_d", context__.to_vec(nobs,npred));
        validate_non_negative_index("pred", "nobs", nobs);
        validate_non_negative_index("pred", "npred", npred);
        pred = matrix_d(static_cast<Eigen::VectorXd::Index>(nobs),static_cast<Eigen::VectorXd::Index>(npred));
        vals_r__ = context__.vals_r("pred");
        pos__ = 0;
        size_t pred_m_mat_lim__ = nobs;
        size_t pred_n_mat_lim__ = npred;
        for (size_t n_mat__ = 0; n_mat__ < pred_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < pred_m_mat_lim__; ++m_mat__) {
                pred(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("pred_m", "nmiss", nmiss);
        validate_non_negative_index("pred_m", "npred", npred);
        context__.validate_dims("data initialization", "pred_m", "matrix_d", context__.to_vec(nmiss,npred));
        validate_non_negative_index("pred_m", "nmiss", nmiss);
        validate_non_negative_index("pred_m", "npred", npred);
        pred_m = matrix_d(static_cast<Eigen::VectorXd::Index>(nmiss),static_cast<Eigen::VectorXd::Index>(npred));
        vals_r__ = context__.vals_r("pred_m");
        pos__ = 0;
        size_t pred_m_m_mat_lim__ = nmiss;
        size_t pred_m_n_mat_lim__ = npred;
        for (size_t n_mat__ = 0; n_mat__ < pred_m_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < pred_m_m_mat_lim__; ++m_mat__) {
                pred_m(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("pred_miss", "nobs", nobs);
        validate_non_negative_index("pred_miss", "npred_miss", npred_miss);
        context__.validate_dims("data initialization", "pred_miss", "matrix_d", context__.to_vec(nobs,npred_miss));
        validate_non_negative_index("pred_miss", "nobs", nobs);
        validate_non_negative_index("pred_miss", "npred_miss", npred_miss);
        pred_miss = matrix_d(static_cast<Eigen::VectorXd::Index>(nobs),static_cast<Eigen::VectorXd::Index>(npred_miss));
        vals_r__ = context__.vals_r("pred_miss");
        pos__ = 0;
        size_t pred_miss_m_mat_lim__ = nobs;
        size_t pred_miss_n_mat_lim__ = npred_miss;
        for (size_t n_mat__ = 0; n_mat__ < pred_miss_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < pred_miss_m_mat_lim__; ++m_mat__) {
                pred_miss(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("pred_miss_m", "nmiss", nmiss);
        validate_non_negative_index("pred_miss_m", "npred_miss", npred_miss);
        context__.validate_dims("data initialization", "pred_miss_m", "matrix_d", context__.to_vec(nmiss,npred_miss));
        validate_non_negative_index("pred_miss_m", "nmiss", nmiss);
        validate_non_negative_index("pred_miss_m", "npred_miss", npred_miss);
        pred_miss_m = matrix_d(static_cast<Eigen::VectorXd::Index>(nmiss),static_cast<Eigen::VectorXd::Index>(npred_miss));
        vals_r__ = context__.vals_r("pred_miss_m");
        pos__ = 0;
        size_t pred_miss_m_m_mat_lim__ = nmiss;
        size_t pred_miss_m_n_mat_lim__ = npred_miss;
        for (size_t n_mat__ = 0; n_mat__ < pred_miss_m_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < pred_miss_m_m_mat_lim__; ++m_mat__) {
                pred_miss_m(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("pred_sub", "nobs", nobs);
        validate_non_negative_index("pred_sub", "npred_sub", npred_sub);
        context__.validate_dims("data initialization", "pred_sub", "matrix_d", context__.to_vec(nobs,npred_sub));
        validate_non_negative_index("pred_sub", "nobs", nobs);
        validate_non_negative_index("pred_sub", "npred_sub", npred_sub);
        pred_sub = matrix_d(static_cast<Eigen::VectorXd::Index>(nobs),static_cast<Eigen::VectorXd::Index>(npred_sub));
        vals_r__ = context__.vals_r("pred_sub");
        pos__ = 0;
        size_t pred_sub_m_mat_lim__ = nobs;
        size_t pred_sub_n_mat_lim__ = npred_sub;
        for (size_t n_mat__ = 0; n_mat__ < pred_sub_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < pred_sub_m_mat_lim__; ++m_mat__) {
                pred_sub(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("pred_sub_m", "nmiss", nmiss);
        validate_non_negative_index("pred_sub_m", "npred_sub", npred_sub);
        context__.validate_dims("data initialization", "pred_sub_m", "matrix_d", context__.to_vec(nmiss,npred_sub));
        validate_non_negative_index("pred_sub_m", "nmiss", nmiss);
        validate_non_negative_index("pred_sub_m", "npred_sub", npred_sub);
        pred_sub_m = matrix_d(static_cast<Eigen::VectorXd::Index>(nmiss),static_cast<Eigen::VectorXd::Index>(npred_sub));
        vals_r__ = context__.vals_r("pred_sub_m");
        pos__ = 0;
        size_t pred_sub_m_m_mat_lim__ = nmiss;
        size_t pred_sub_m_n_mat_lim__ = npred_sub;
        for (size_t n_mat__ = 0; n_mat__ < pred_sub_m_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < pred_sub_m_m_mat_lim__; ++m_mat__) {
                pred_sub_m(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("y", "nobs", nobs);
        context__.validate_dims("data initialization", "y", "double", context__.to_vec(nobs));
        validate_non_negative_index("y", "nobs", nobs);
        y = std::vector<double>(nobs,double(0));
        vals_r__ = context__.vals_r("y");
        pos__ = 0;
        size_t y_limit_0__ = nobs;
        for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
            y[i_0__] = vals_r__[pos__++];
        }
        validate_non_negative_index("miss_m", "nmiss", nmiss);
        context__.validate_dims("data initialization", "miss_m", "int", context__.to_vec(nmiss));
        validate_non_negative_index("miss_m", "nmiss", nmiss);
        miss_m = std::vector<int>(nmiss,int(0));
        vals_i__ = context__.vals_i("miss_m");
        pos__ = 0;
        size_t miss_m_limit_0__ = nmiss;
        for (size_t i_0__ = 0; i_0__ < miss_m_limit_0__; ++i_0__) {
            miss_m[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("miss_obs", "nobs", nobs);
        context__.validate_dims("data initialization", "miss_obs", "int", context__.to_vec(nobs));
        validate_non_negative_index("miss_obs", "nobs", nobs);
        miss_obs = std::vector<int>(nobs,int(0));
        vals_i__ = context__.vals_i("miss_obs");
        pos__ = 0;
        size_t miss_obs_limit_0__ = nobs;
        for (size_t i_0__ = 0; i_0__ < miss_obs_limit_0__; ++i_0__) {
            miss_obs[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("R", "npred", npred);
        validate_non_negative_index("R", "npred", npred);
        context__.validate_dims("data initialization", "R", "matrix_d", context__.to_vec(npred,npred));
        validate_non_negative_index("R", "npred", npred);
        validate_non_negative_index("R", "npred", npred);
        R = matrix_d(static_cast<Eigen::VectorXd::Index>(npred),static_cast<Eigen::VectorXd::Index>(npred));
        vals_r__ = context__.vals_r("R");
        pos__ = 0;
        size_t R_k_mat_lim__ = npred;
        for (size_t n_mat__ = 0; n_mat__ < R_k_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < R_k_mat_lim__; ++m_mat__) {
                R(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("Sigma_sd", "npred", npred);
        context__.validate_dims("data initialization", "Sigma_sd", "vector_d", context__.to_vec(npred));
        validate_non_negative_index("Sigma_sd", "npred", npred);
        Sigma_sd = vector_d(static_cast<Eigen::VectorXd::Index>(npred));
        vals_r__ = context__.vals_r("Sigma_sd");
        pos__ = 0;
        size_t Sigma_sd_i_vec_lim__ = npred;
        for (size_t i_vec__ = 0; i_vec__ < Sigma_sd_i_vec_lim__; ++i_vec__) {
            Sigma_sd[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("prec", "npred", npred);
        validate_non_negative_index("prec", "npred", npred);
        context__.validate_dims("data initialization", "prec", "matrix_d", context__.to_vec(npred,npred));
        validate_non_negative_index("prec", "npred", npred);
        validate_non_negative_index("prec", "npred", npred);
        prec = matrix_d(static_cast<Eigen::VectorXd::Index>(npred),static_cast<Eigen::VectorXd::Index>(npred));
        vals_r__ = context__.vals_r("prec");
        pos__ = 0;
        size_t prec_k_mat_lim__ = npred;
        for (size_t n_mat__ = 0; n_mat__ < prec_k_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < prec_k_mat_lim__; ++m_mat__) {
                prec(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("mn", "npred", npred);
        context__.validate_dims("data initialization", "mn", "vector_d", context__.to_vec(npred));
        validate_non_negative_index("mn", "npred", npred);
        mn = vector_d(static_cast<Eigen::VectorXd::Index>(npred));
        vals_r__ = context__.vals_r("mn");
        pos__ = 0;
        size_t mn_i_vec_lim__ = npred;
        for (size_t i_vec__ = 0; i_vec__ < mn_i_vec_lim__; ++i_vec__) {
            mn[i_vec__] = vals_r__[pos__++];
        }

        // validate, data variables
        check_greater_or_equal(function__,"nobs",nobs,0);
        for (int k0__ = 0; k0__ < nobs; ++k0__) {
            check_greater_or_equal(function__,"sid[k0__]",sid[k0__],0);
        }
        for (int k0__ = 0; k0__ < nmiss; ++k0__) {
            check_greater_or_equal(function__,"sid_m[k0__]",sid_m[k0__],0);
        }
        for (int k0__ = 0; k0__ < nobs; ++k0__) {
            check_greater_or_equal(function__,"pid[k0__]",pid[k0__],0);
        }
        for (int k0__ = 0; k0__ < nmiss; ++k0__) {
            check_greater_or_equal(function__,"pid_m[k0__]",pid_m[k0__],0);
        }
        stan::math::check_corr_matrix(function__,"R",R);
        stan::math::check_cov_matrix(function__,"prec",prec);
        // initialize data variables
        validate_non_negative_index("T", "npred", npred);
        validate_non_negative_index("T", "npred", npred);
        T = matrix_d(static_cast<Eigen::VectorXd::Index>(npred),static_cast<Eigen::VectorXd::Index>(npred));
        stan::math::fill(T,DUMMY_VAR__);
        validate_non_negative_index("invprec", "npred", npred);
        validate_non_negative_index("invprec", "npred", npred);
        invprec = matrix_d(static_cast<Eigen::VectorXd::Index>(npred),static_cast<Eigen::VectorXd::Index>(npred));
        stan::math::fill(invprec,DUMMY_VAR__);

        try {
            current_statement_begin__ = 39;
            stan::math::assign(T, multiply(multiply(diag_matrix(Sigma_sd),R),diag_matrix(Sigma_sd)));
            current_statement_begin__ = 40;
            stan::math::assign(invprec, inverse(prec));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data
        stan::math::check_cov_matrix(function__,"T",T);
        stan::math::check_cov_matrix(function__,"invprec",invprec);

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        validate_non_negative_index("U_latent", "np", np);
        validate_non_negative_index("U_latent", "npred", npred);
        num_params_r__ += np * npred;
        validate_non_negative_index("g", "npred", npred);
        num_params_r__ += npred;
        validate_non_negative_index("pVAR", "npred", npred);
        num_params_r__ += ((npred * (npred - 1)) / 2 + npred);
        ++num_params_r__;
        validate_non_negative_index("alpha_latent", "npred_miss", npred_miss);
        num_params_r__ += npred_miss;
        validate_non_negative_index("alpha_mu", "npred_miss", npred_miss);
        num_params_r__ += npred_miss;
        validate_non_negative_index("alpha_theta", "npred_miss", npred_miss);
        num_params_r__ += npred_miss;
        ++num_params_r__;
        validate_non_negative_index("beta2_latent", "nsid", nsid);
        validate_non_negative_index("beta2_latent", "npred_sub", npred_sub);
        num_params_r__ += nsid * npred_sub;
        validate_non_negative_index("beta2_theta", "npred_sub", npred_sub);
        num_params_r__ += npred_sub;
        validate_non_negative_index("beta2_mu", "nsid", nsid);
        validate_non_negative_index("beta2_mu", "npred_sub", npred_sub);
        num_params_r__ += nsid * npred_sub;
        validate_non_negative_index("y_m_latent", "nmiss", nmiss);
        num_params_r__ += nmiss;
    }

    ~model_mmlm_code() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("U_latent")))
            throw std::runtime_error("variable U_latent missing");
        vals_r__ = context__.vals_r("U_latent");
        pos__ = 0U;
        validate_non_negative_index("U_latent", "np", np);
        validate_non_negative_index("U_latent", "npred", npred);
        context__.validate_dims("initialization", "U_latent", "matrix_d", context__.to_vec(np,npred));
        // generate_declaration U_latent
        matrix_d U_latent(static_cast<Eigen::VectorXd::Index>(np),static_cast<Eigen::VectorXd::Index>(npred));
        for (int j2__ = 0U; j2__ < npred; ++j2__)
            for (int j1__ = 0U; j1__ < np; ++j1__)
                U_latent(j1__,j2__) = vals_r__[pos__++];
        try {
            writer__.matrix_unconstrain(U_latent);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable U_latent: ") + e.what());
        }

        if (!(context__.contains_r("g")))
            throw std::runtime_error("variable g missing");
        vals_r__ = context__.vals_r("g");
        pos__ = 0U;
        validate_non_negative_index("g", "npred", npred);
        context__.validate_dims("initialization", "g", "row_vector_d", context__.to_vec(npred));
        // generate_declaration g
        row_vector_d g(static_cast<Eigen::VectorXd::Index>(npred));
        for (int j1__ = 0U; j1__ < npred; ++j1__)
            g(j1__) = vals_r__[pos__++];
        try {
            writer__.row_vector_unconstrain(g);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable g: ") + e.what());
        }

        if (!(context__.contains_r("pVAR")))
            throw std::runtime_error("variable pVAR missing");
        vals_r__ = context__.vals_r("pVAR");
        pos__ = 0U;
        validate_non_negative_index("pVAR", "npred", npred);
        validate_non_negative_index("pVAR", "npred", npred);
        context__.validate_dims("initialization", "pVAR", "matrix_d", context__.to_vec(npred,npred));
        // generate_declaration pVAR
        matrix_d pVAR(static_cast<Eigen::VectorXd::Index>(npred),static_cast<Eigen::VectorXd::Index>(npred));
        for (int j2__ = 0U; j2__ < npred; ++j2__)
            for (int j1__ = 0U; j1__ < npred; ++j1__)
                pVAR(j1__,j2__) = vals_r__[pos__++];
        try {
            writer__.cov_matrix_unconstrain(pVAR);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable pVAR: ") + e.what());
        }

        if (!(context__.contains_r("ita")))
            throw std::runtime_error("variable ita missing");
        vals_r__ = context__.vals_r("ita");
        pos__ = 0U;
        context__.validate_dims("initialization", "ita", "double", context__.to_vec());
        // generate_declaration ita
        double ita(0);
        ita = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,ita);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable ita: ") + e.what());
        }

        if (!(context__.contains_r("alpha_latent")))
            throw std::runtime_error("variable alpha_latent missing");
        vals_r__ = context__.vals_r("alpha_latent");
        pos__ = 0U;
        validate_non_negative_index("alpha_latent", "npred_miss", npred_miss);
        context__.validate_dims("initialization", "alpha_latent", "vector_d", context__.to_vec(npred_miss));
        // generate_declaration alpha_latent
        vector_d alpha_latent(static_cast<Eigen::VectorXd::Index>(npred_miss));
        for (int j1__ = 0U; j1__ < npred_miss; ++j1__)
            alpha_latent(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(alpha_latent);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha_latent: ") + e.what());
        }

        if (!(context__.contains_r("alpha_mu")))
            throw std::runtime_error("variable alpha_mu missing");
        vals_r__ = context__.vals_r("alpha_mu");
        pos__ = 0U;
        validate_non_negative_index("alpha_mu", "npred_miss", npred_miss);
        context__.validate_dims("initialization", "alpha_mu", "vector_d", context__.to_vec(npred_miss));
        // generate_declaration alpha_mu
        vector_d alpha_mu(static_cast<Eigen::VectorXd::Index>(npred_miss));
        for (int j1__ = 0U; j1__ < npred_miss; ++j1__)
            alpha_mu(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(alpha_mu);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha_mu: ") + e.what());
        }

        if (!(context__.contains_r("alpha_theta")))
            throw std::runtime_error("variable alpha_theta missing");
        vals_r__ = context__.vals_r("alpha_theta");
        pos__ = 0U;
        validate_non_negative_index("alpha_theta", "npred_miss", npred_miss);
        context__.validate_dims("initialization", "alpha_theta", "vector_d", context__.to_vec(npred_miss));
        // generate_declaration alpha_theta
        vector_d alpha_theta(static_cast<Eigen::VectorXd::Index>(npred_miss));
        for (int j1__ = 0U; j1__ < npred_miss; ++j1__)
            alpha_theta(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(alpha_theta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha_theta: ") + e.what());
        }

        if (!(context__.contains_r("alpha_response")))
            throw std::runtime_error("variable alpha_response missing");
        vals_r__ = context__.vals_r("alpha_response");
        pos__ = 0U;
        context__.validate_dims("initialization", "alpha_response", "double", context__.to_vec());
        // generate_declaration alpha_response
        double alpha_response(0);
        alpha_response = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(alpha_response);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha_response: ") + e.what());
        }

        if (!(context__.contains_r("beta2_latent")))
            throw std::runtime_error("variable beta2_latent missing");
        vals_r__ = context__.vals_r("beta2_latent");
        pos__ = 0U;
        validate_non_negative_index("beta2_latent", "nsid", nsid);
        validate_non_negative_index("beta2_latent", "npred_sub", npred_sub);
        context__.validate_dims("initialization", "beta2_latent", "matrix_d", context__.to_vec(nsid,npred_sub));
        // generate_declaration beta2_latent
        matrix_d beta2_latent(static_cast<Eigen::VectorXd::Index>(nsid),static_cast<Eigen::VectorXd::Index>(npred_sub));
        for (int j2__ = 0U; j2__ < npred_sub; ++j2__)
            for (int j1__ = 0U; j1__ < nsid; ++j1__)
                beta2_latent(j1__,j2__) = vals_r__[pos__++];
        try {
            writer__.matrix_unconstrain(beta2_latent);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta2_latent: ") + e.what());
        }

        if (!(context__.contains_r("beta2_theta")))
            throw std::runtime_error("variable beta2_theta missing");
        vals_r__ = context__.vals_r("beta2_theta");
        pos__ = 0U;
        validate_non_negative_index("beta2_theta", "npred_sub", npred_sub);
        context__.validate_dims("initialization", "beta2_theta", "row_vector_d", context__.to_vec(npred_sub));
        // generate_declaration beta2_theta
        row_vector_d beta2_theta(static_cast<Eigen::VectorXd::Index>(npred_sub));
        for (int j1__ = 0U; j1__ < npred_sub; ++j1__)
            beta2_theta(j1__) = vals_r__[pos__++];
        try {
            writer__.row_vector_unconstrain(beta2_theta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta2_theta: ") + e.what());
        }

        if (!(context__.contains_r("beta2_mu")))
            throw std::runtime_error("variable beta2_mu missing");
        vals_r__ = context__.vals_r("beta2_mu");
        pos__ = 0U;
        validate_non_negative_index("beta2_mu", "nsid", nsid);
        validate_non_negative_index("beta2_mu", "npred_sub", npred_sub);
        context__.validate_dims("initialization", "beta2_mu", "matrix_d", context__.to_vec(nsid,npred_sub));
        // generate_declaration beta2_mu
        matrix_d beta2_mu(static_cast<Eigen::VectorXd::Index>(nsid),static_cast<Eigen::VectorXd::Index>(npred_sub));
        for (int j2__ = 0U; j2__ < npred_sub; ++j2__)
            for (int j1__ = 0U; j1__ < nsid; ++j1__)
                beta2_mu(j1__,j2__) = vals_r__[pos__++];
        try {
            writer__.matrix_unconstrain(beta2_mu);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta2_mu: ") + e.what());
        }

        if (!(context__.contains_r("y_m_latent")))
            throw std::runtime_error("variable y_m_latent missing");
        vals_r__ = context__.vals_r("y_m_latent");
        pos__ = 0U;
        validate_non_negative_index("y_m_latent", "nmiss", nmiss);
        context__.validate_dims("initialization", "y_m_latent", "double", context__.to_vec(nmiss));
        // generate_declaration y_m_latent
        std::vector<double> y_m_latent(nmiss,double(0));
        for (int i0__ = 0U; i0__ < nmiss; ++i0__)
            y_m_latent[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < nmiss; ++i0__)
            try {
            writer__.scalar_unconstrain(y_m_latent[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable y_m_latent: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  U_latent;
        (void) U_latent;  // dummy to suppress unused var warning
        if (jacobian__)
            U_latent = in__.matrix_constrain(np,npred,lp__);
        else
            U_latent = in__.matrix_constrain(np,npred);

        Eigen::Matrix<T__,1,Eigen::Dynamic>  g;
        (void) g;  // dummy to suppress unused var warning
        if (jacobian__)
            g = in__.row_vector_constrain(npred,lp__);
        else
            g = in__.row_vector_constrain(npred);

        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  pVAR;
        (void) pVAR;  // dummy to suppress unused var warning
        if (jacobian__)
            pVAR = in__.cov_matrix_constrain(npred,lp__);
        else
            pVAR = in__.cov_matrix_constrain(npred);

        T__ ita;
        (void) ita;  // dummy to suppress unused var warning
        if (jacobian__)
            ita = in__.scalar_lb_constrain(0,lp__);
        else
            ita = in__.scalar_lb_constrain(0);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  alpha_latent;
        (void) alpha_latent;  // dummy to suppress unused var warning
        if (jacobian__)
            alpha_latent = in__.vector_constrain(npred_miss,lp__);
        else
            alpha_latent = in__.vector_constrain(npred_miss);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  alpha_mu;
        (void) alpha_mu;  // dummy to suppress unused var warning
        if (jacobian__)
            alpha_mu = in__.vector_constrain(npred_miss,lp__);
        else
            alpha_mu = in__.vector_constrain(npred_miss);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  alpha_theta;
        (void) alpha_theta;  // dummy to suppress unused var warning
        if (jacobian__)
            alpha_theta = in__.vector_constrain(npred_miss,lp__);
        else
            alpha_theta = in__.vector_constrain(npred_miss);

        T__ alpha_response;
        (void) alpha_response;  // dummy to suppress unused var warning
        if (jacobian__)
            alpha_response = in__.scalar_constrain(lp__);
        else
            alpha_response = in__.scalar_constrain();

        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  beta2_latent;
        (void) beta2_latent;  // dummy to suppress unused var warning
        if (jacobian__)
            beta2_latent = in__.matrix_constrain(nsid,npred_sub,lp__);
        else
            beta2_latent = in__.matrix_constrain(nsid,npred_sub);

        Eigen::Matrix<T__,1,Eigen::Dynamic>  beta2_theta;
        (void) beta2_theta;  // dummy to suppress unused var warning
        if (jacobian__)
            beta2_theta = in__.row_vector_constrain(npred_sub,lp__);
        else
            beta2_theta = in__.row_vector_constrain(npred_sub);

        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  beta2_mu;
        (void) beta2_mu;  // dummy to suppress unused var warning
        if (jacobian__)
            beta2_mu = in__.matrix_constrain(nsid,npred_sub,lp__);
        else
            beta2_mu = in__.matrix_constrain(nsid,npred_sub);

        vector<T__> y_m_latent;
        size_t dim_y_m_latent_0__ = nmiss;
        y_m_latent.reserve(dim_y_m_latent_0__);
        for (size_t k_0__ = 0; k_0__ < dim_y_m_latent_0__; ++k_0__) {
            if (jacobian__)
                y_m_latent.push_back(in__.scalar_constrain(lp__));
            else
                y_m_latent.push_back(in__.scalar_constrain());
        }


        // transformed parameters
        validate_non_negative_index("U", "np", np);
        validate_non_negative_index("U", "npred", npred);
        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  U(static_cast<Eigen::VectorXd::Index>(np),static_cast<Eigen::VectorXd::Index>(npred));
        (void) U;  // dummy to suppress unused var warning

        stan::math::initialize(U, DUMMY_VAR__);
        stan::math::fill(U,DUMMY_VAR__);
        validate_non_negative_index("beta2", "nsid", nsid);
        validate_non_negative_index("beta2", "npred_sub", npred_sub);
        Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  beta2(static_cast<Eigen::VectorXd::Index>(nsid),static_cast<Eigen::VectorXd::Index>(npred_sub));
        (void) beta2;  // dummy to suppress unused var warning

        stan::math::initialize(beta2, DUMMY_VAR__);
        stan::math::fill(beta2,DUMMY_VAR__);
        validate_non_negative_index("alpha", "npred_miss", npred_miss);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  alpha(static_cast<Eigen::VectorXd::Index>(npred_miss));
        (void) alpha;  // dummy to suppress unused var warning

        stan::math::initialize(alpha, DUMMY_VAR__);
        stan::math::fill(alpha,DUMMY_VAR__);
        validate_non_negative_index("mu", "nobs", nobs);
        vector<T__> mu(nobs);
        stan::math::initialize(mu, DUMMY_VAR__);
        stan::math::fill(mu,DUMMY_VAR__);
        validate_non_negative_index("mu_m", "nmiss", nmiss);
        vector<T__> mu_m(nmiss);
        stan::math::initialize(mu_m, DUMMY_VAR__);
        stan::math::fill(mu_m,DUMMY_VAR__);
        validate_non_negative_index("y_m", "nmiss", nmiss);
        vector<T__> y_m(nmiss);
        stan::math::initialize(y_m, DUMMY_VAR__);
        stan::math::fill(y_m,DUMMY_VAR__);
        validate_non_negative_index("pmiss", "nobs", nobs);
        vector<T__> pmiss(nobs);
        stan::math::initialize(pmiss, DUMMY_VAR__);
        stan::math::fill(pmiss,DUMMY_VAR__);
        validate_non_negative_index("pmiss_m", "nmiss", nmiss);
        vector<T__> pmiss_m(nmiss);
        stan::math::initialize(pmiss_m, DUMMY_VAR__);
        stan::math::fill(pmiss_m,DUMMY_VAR__);


        try {
            current_statement_begin__ = 74;
            for (int sub = 1; sub <= nsid; ++sub) {
                current_statement_begin__ = 75;
                stan::math::assign(get_base1_lhs(beta2,sub,"beta2",1), add(get_base1(beta2_mu,sub,"beta2_mu",1),dot_product(beta2_theta,get_base1(beta2_latent,sub,"beta2_latent",1))));
            }
            current_statement_begin__ = 77;
            for (int prot = 1; prot <= np; ++prot) {
                current_statement_begin__ = 78;
                stan::math::assign(get_base1_lhs(U,prot,"U",1), add(g,multiply(get_base1(U_latent,prot,"U_latent",1),pVAR)));
            }
            current_statement_begin__ = 80;
            stan::math::assign(alpha, add(alpha_mu,dot_product(alpha_theta,alpha_latent)));
            current_statement_begin__ = 82;
            for (int pep = 1; pep <= nobs; ++pep) {

                current_statement_begin__ = 83;
                stan::math::assign(get_base1_lhs(mu,pep,"mu",1), (dot_product(get_base1(pred_sub,pep,"pred_sub",1),get_base1(beta2,get_base1(sid,pep,"sid",1),"beta2",1)) + dot_product(get_base1(pred,pep,"pred",1),get_base1(U,get_base1(pid,pep,"pid",1),"U",1))));
                current_statement_begin__ = 84;
                if (as_bool(logical_eq(respond_dep,1))) {
                    current_statement_begin__ = 84;
                    stan::math::assign(get_base1_lhs(pmiss,pep,"pmiss",1), inv_logit((dot_product(alpha,get_base1(pred_miss,pep,"pred_miss",1)) + (alpha_response * get_base1(mu,pep,"mu",1)))));
                } else {
                    current_statement_begin__ = 85;
                    stan::math::assign(get_base1_lhs(pmiss,pep,"pmiss",1), inv_logit(dot_product(alpha,get_base1(pred_miss,pep,"pred_miss",1))));
                }
                current_statement_begin__ = 86;
                if (as_bool(logical_eq(get_base1(pmiss,pep,"pmiss",1),0))) {
                    current_statement_begin__ = 86;
                    stan::math::assign(get_base1_lhs(pmiss,pep,"pmiss",1), 0.001);
                }
                current_statement_begin__ = 87;
                if (as_bool(logical_eq(get_base1(pmiss,pep,"pmiss",1),1))) {
                    current_statement_begin__ = 87;
                    stan::math::assign(get_base1_lhs(pmiss,pep,"pmiss",1), 0.999);
                }
            }
            current_statement_begin__ = 90;
            for (int pep2 = 1; pep2 <= nmiss; ++pep2) {

                current_statement_begin__ = 91;
                stan::math::assign(get_base1_lhs(mu_m,pep2,"mu_m",1), (dot_product(get_base1(beta2,get_base1(sid_m,pep2,"sid_m",1),"beta2",1),get_base1(pred_sub_m,pep2,"pred_sub_m",1)) + dot_product(get_base1(pred_m,pep2,"pred_m",1),get_base1(U,get_base1(pid_m,pep2,"pid_m",1),"U",1))));
                current_statement_begin__ = 92;
                stan::math::assign(get_base1_lhs(y_m,pep2,"y_m",1), (get_base1(mu_m,pep2,"mu_m",1) + (get_base1(y_m_latent,pep2,"y_m_latent",1) * ita)));
                current_statement_begin__ = 93;
                if (as_bool(logical_eq(respond_dep,1))) {
                    current_statement_begin__ = 93;
                    stan::math::assign(get_base1_lhs(pmiss_m,pep2,"pmiss_m",1), inv_logit((dot_product(alpha,get_base1(pred_miss_m,pep2,"pred_miss_m",1)) + (alpha_response * get_base1(mu_m,pep2,"mu_m",1)))));
                } else {
                    current_statement_begin__ = 94;
                    stan::math::assign(get_base1_lhs(pmiss_m,pep2,"pmiss_m",1), inv_logit(dot_product(alpha,get_base1(pred_miss,pep2,"pred_miss",1))));
                }
                current_statement_begin__ = 96;
                if (as_bool(logical_eq(get_base1(pmiss_m,pep2,"pmiss_m",1),0))) {
                    current_statement_begin__ = 96;
                    stan::math::assign(get_base1_lhs(pmiss_m,pep2,"pmiss_m",1), 0.001);
                }
                current_statement_begin__ = 97;
                if (as_bool(logical_eq(get_base1(pmiss_m,pep2,"pmiss_m",1),1))) {
                    current_statement_begin__ = 97;
                    stan::math::assign(get_base1_lhs(pmiss_m,pep2,"pmiss_m",1), 0.999);
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < np; ++i0__) {
            for (int i1__ = 0; i1__ < npred; ++i1__) {
                if (stan::math::is_uninitialized(U(i0__,i1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: U" << '[' << i0__ << ']' << '[' << i1__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
        }
        for (int i0__ = 0; i0__ < nsid; ++i0__) {
            for (int i1__ = 0; i1__ < npred_sub; ++i1__) {
                if (stan::math::is_uninitialized(beta2(i0__,i1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta2" << '[' << i0__ << ']' << '[' << i1__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
        }
        for (int i0__ = 0; i0__ < npred_miss; ++i0__) {
            if (stan::math::is_uninitialized(alpha(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: alpha" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < nobs; ++i0__) {
            if (stan::math::is_uninitialized(mu[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: mu" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < nmiss; ++i0__) {
            if (stan::math::is_uninitialized(mu_m[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: mu_m" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < nmiss; ++i0__) {
            if (stan::math::is_uninitialized(y_m[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: y_m" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < nobs; ++i0__) {
            if (stan::math::is_uninitialized(pmiss[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: pmiss" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < nmiss; ++i0__) {
            if (stan::math::is_uninitialized(pmiss_m[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: pmiss_m" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        for (int k0__ = 0; k0__ < nobs; ++k0__) {
            check_greater_or_equal(function__,"pmiss[k0__]",pmiss[k0__],0);
            check_less_or_equal(function__,"pmiss[k0__]",pmiss[k0__],1);
        }
        for (int k0__ = 0; k0__ < nmiss; ++k0__) {
            check_greater_or_equal(function__,"pmiss_m[k0__]",pmiss_m[k0__],0);
            check_less_or_equal(function__,"pmiss_m[k0__]",pmiss_m[k0__],1);
        }

        // model body
        try {

            current_statement_begin__ = 104;
            for (int sub = 1; sub <= nsid; ++sub) {

                current_statement_begin__ = 105;
                lp_accum__.add(normal_log<propto__>(get_base1(beta2_latent,sub,"beta2_latent",1), 0, 1));
                current_statement_begin__ = 106;
                lp_accum__.add(normal_log<propto__>(get_base1(beta2_mu,sub,"beta2_mu",1), 0, 1));
            }
            current_statement_begin__ = 107;
            lp_accum__.add(gamma_log<propto__>(beta2_theta, 1, 1));
            current_statement_begin__ = 109;
            lp_accum__.add(multi_normal_log<propto__>(g, mn, T));
            current_statement_begin__ = 110;
            lp_accum__.add(inv_wishart_log<propto__>(pVAR, npred, invprec));
            current_statement_begin__ = 112;
            for (int prot = 1; prot <= np; ++prot) {
                current_statement_begin__ = 113;
                lp_accum__.add(multi_normal_log<propto__>(get_base1(U_latent,prot,"U_latent",1), mn, R));
            }
            current_statement_begin__ = 115;
            lp_accum__.add(gamma_log<propto__>(ita, 1, 1));
            current_statement_begin__ = 116;
            lp_accum__.add(normal_log<propto__>(y, mu, ita));
            current_statement_begin__ = 118;
            lp_accum__.add(normal_log<propto__>(alpha_latent, 0, 1));
            current_statement_begin__ = 119;
            lp_accum__.add(normal_log<propto__>(alpha_mu, 0, 1));
            current_statement_begin__ = 120;
            lp_accum__.add(gamma_log<propto__>(alpha_theta, 1, 1));
            current_statement_begin__ = 121;
            lp_accum__.add(normal_log<propto__>(alpha_response, 0, 1));
            current_statement_begin__ = 123;
            for (int pep = 1; pep <= nobs; ++pep) {
                current_statement_begin__ = 124;
                lp_accum__.add(bernoulli_log<propto__>(get_base1(miss_obs,pep,"miss_obs",1), get_base1(pmiss,pep,"pmiss",1)));
            }
            current_statement_begin__ = 126;
            for (int pep2 = 1; pep2 <= nmiss; ++pep2) {

                current_statement_begin__ = 127;
                lp_accum__.add(bernoulli_log<propto__>(get_base1(miss_m,pep2,"miss_m",1), get_base1(pmiss_m,pep2,"pmiss_m",1)));
                current_statement_begin__ = 128;
                lp_accum__.add(normal_log<propto__>(get_base1(y_m_latent,pep2,"y_m_latent",1), 0, 1));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("U_latent");
        names__.push_back("g");
        names__.push_back("pVAR");
        names__.push_back("ita");
        names__.push_back("alpha_latent");
        names__.push_back("alpha_mu");
        names__.push_back("alpha_theta");
        names__.push_back("alpha_response");
        names__.push_back("beta2_latent");
        names__.push_back("beta2_theta");
        names__.push_back("beta2_mu");
        names__.push_back("y_m_latent");
        names__.push_back("U");
        names__.push_back("beta2");
        names__.push_back("alpha");
        names__.push_back("mu");
        names__.push_back("mu_m");
        names__.push_back("y_m");
        names__.push_back("pmiss");
        names__.push_back("pmiss_m");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(np);
        dims__.push_back(npred);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(npred);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(npred);
        dims__.push_back(npred);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(npred_miss);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(npred_miss);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(npred_miss);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nsid);
        dims__.push_back(npred_sub);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(npred_sub);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nsid);
        dims__.push_back(npred_sub);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nmiss);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(np);
        dims__.push_back(npred);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nsid);
        dims__.push_back(npred_sub);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(npred_miss);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nobs);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nmiss);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nmiss);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nobs);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nmiss);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_mmlm_code_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        matrix_d U_latent = in__.matrix_constrain(np,npred);
        row_vector_d g = in__.row_vector_constrain(npred);
        matrix_d pVAR = in__.cov_matrix_constrain(npred);
        double ita = in__.scalar_lb_constrain(0);
        vector_d alpha_latent = in__.vector_constrain(npred_miss);
        vector_d alpha_mu = in__.vector_constrain(npred_miss);
        vector_d alpha_theta = in__.vector_constrain(npred_miss);
        double alpha_response = in__.scalar_constrain();
        matrix_d beta2_latent = in__.matrix_constrain(nsid,npred_sub);
        row_vector_d beta2_theta = in__.row_vector_constrain(npred_sub);
        matrix_d beta2_mu = in__.matrix_constrain(nsid,npred_sub);
        vector<double> y_m_latent;
        size_t dim_y_m_latent_0__ = nmiss;
        for (size_t k_0__ = 0; k_0__ < dim_y_m_latent_0__; ++k_0__) {
            y_m_latent.push_back(in__.scalar_constrain());
        }
        for (int k_1__ = 0; k_1__ < npred; ++k_1__) {
            for (int k_0__ = 0; k_0__ < np; ++k_0__) {
                vars__.push_back(U_latent(k_0__, k_1__));
            }
        }
        for (int k_0__ = 0; k_0__ < npred; ++k_0__) {
            vars__.push_back(g[k_0__]);
        }
        for (int k_1__ = 0; k_1__ < npred; ++k_1__) {
            for (int k_0__ = 0; k_0__ < npred; ++k_0__) {
                vars__.push_back(pVAR(k_0__, k_1__));
            }
        }
        vars__.push_back(ita);
        for (int k_0__ = 0; k_0__ < npred_miss; ++k_0__) {
            vars__.push_back(alpha_latent[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < npred_miss; ++k_0__) {
            vars__.push_back(alpha_mu[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < npred_miss; ++k_0__) {
            vars__.push_back(alpha_theta[k_0__]);
        }
        vars__.push_back(alpha_response);
        for (int k_1__ = 0; k_1__ < npred_sub; ++k_1__) {
            for (int k_0__ = 0; k_0__ < nsid; ++k_0__) {
                vars__.push_back(beta2_latent(k_0__, k_1__));
            }
        }
        for (int k_0__ = 0; k_0__ < npred_sub; ++k_0__) {
            vars__.push_back(beta2_theta[k_0__]);
        }
        for (int k_1__ = 0; k_1__ < npred_sub; ++k_1__) {
            for (int k_0__ = 0; k_0__ < nsid; ++k_0__) {
                vars__.push_back(beta2_mu(k_0__, k_1__));
            }
        }
        for (int k_0__ = 0; k_0__ < nmiss; ++k_0__) {
            vars__.push_back(y_m_latent[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        validate_non_negative_index("U", "np", np);
        validate_non_negative_index("U", "npred", npred);
        matrix_d U(static_cast<Eigen::VectorXd::Index>(np),static_cast<Eigen::VectorXd::Index>(npred));
        (void) U;  // dummy to suppress unused var warning

        stan::math::initialize(U, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(U,DUMMY_VAR__);
        validate_non_negative_index("beta2", "nsid", nsid);
        validate_non_negative_index("beta2", "npred_sub", npred_sub);
        matrix_d beta2(static_cast<Eigen::VectorXd::Index>(nsid),static_cast<Eigen::VectorXd::Index>(npred_sub));
        (void) beta2;  // dummy to suppress unused var warning

        stan::math::initialize(beta2, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(beta2,DUMMY_VAR__);
        validate_non_negative_index("alpha", "npred_miss", npred_miss);
        vector_d alpha(static_cast<Eigen::VectorXd::Index>(npred_miss));
        (void) alpha;  // dummy to suppress unused var warning

        stan::math::initialize(alpha, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(alpha,DUMMY_VAR__);
        validate_non_negative_index("mu", "nobs", nobs);
        vector<double> mu(nobs, 0.0);
        stan::math::initialize(mu, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu,DUMMY_VAR__);
        validate_non_negative_index("mu_m", "nmiss", nmiss);
        vector<double> mu_m(nmiss, 0.0);
        stan::math::initialize(mu_m, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu_m,DUMMY_VAR__);
        validate_non_negative_index("y_m", "nmiss", nmiss);
        vector<double> y_m(nmiss, 0.0);
        stan::math::initialize(y_m, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(y_m,DUMMY_VAR__);
        validate_non_negative_index("pmiss", "nobs", nobs);
        vector<double> pmiss(nobs, 0.0);
        stan::math::initialize(pmiss, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pmiss,DUMMY_VAR__);
        validate_non_negative_index("pmiss_m", "nmiss", nmiss);
        vector<double> pmiss_m(nmiss, 0.0);
        stan::math::initialize(pmiss_m, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pmiss_m,DUMMY_VAR__);


        try {
            current_statement_begin__ = 74;
            for (int sub = 1; sub <= nsid; ++sub) {
                current_statement_begin__ = 75;
                stan::math::assign(get_base1_lhs(beta2,sub,"beta2",1), add(get_base1(beta2_mu,sub,"beta2_mu",1),dot_product(beta2_theta,get_base1(beta2_latent,sub,"beta2_latent",1))));
            }
            current_statement_begin__ = 77;
            for (int prot = 1; prot <= np; ++prot) {
                current_statement_begin__ = 78;
                stan::math::assign(get_base1_lhs(U,prot,"U",1), add(g,multiply(get_base1(U_latent,prot,"U_latent",1),pVAR)));
            }
            current_statement_begin__ = 80;
            stan::math::assign(alpha, add(alpha_mu,dot_product(alpha_theta,alpha_latent)));
            current_statement_begin__ = 82;
            for (int pep = 1; pep <= nobs; ++pep) {

                current_statement_begin__ = 83;
                stan::math::assign(get_base1_lhs(mu,pep,"mu",1), (dot_product(get_base1(pred_sub,pep,"pred_sub",1),get_base1(beta2,get_base1(sid,pep,"sid",1),"beta2",1)) + dot_product(get_base1(pred,pep,"pred",1),get_base1(U,get_base1(pid,pep,"pid",1),"U",1))));
                current_statement_begin__ = 84;
                if (as_bool(logical_eq(respond_dep,1))) {
                    current_statement_begin__ = 84;
                    stan::math::assign(get_base1_lhs(pmiss,pep,"pmiss",1), inv_logit((dot_product(alpha,get_base1(pred_miss,pep,"pred_miss",1)) + (alpha_response * get_base1(mu,pep,"mu",1)))));
                } else {
                    current_statement_begin__ = 85;
                    stan::math::assign(get_base1_lhs(pmiss,pep,"pmiss",1), inv_logit(dot_product(alpha,get_base1(pred_miss,pep,"pred_miss",1))));
                }
                current_statement_begin__ = 86;
                if (as_bool(logical_eq(get_base1(pmiss,pep,"pmiss",1),0))) {
                    current_statement_begin__ = 86;
                    stan::math::assign(get_base1_lhs(pmiss,pep,"pmiss",1), 0.001);
                }
                current_statement_begin__ = 87;
                if (as_bool(logical_eq(get_base1(pmiss,pep,"pmiss",1),1))) {
                    current_statement_begin__ = 87;
                    stan::math::assign(get_base1_lhs(pmiss,pep,"pmiss",1), 0.999);
                }
            }
            current_statement_begin__ = 90;
            for (int pep2 = 1; pep2 <= nmiss; ++pep2) {

                current_statement_begin__ = 91;
                stan::math::assign(get_base1_lhs(mu_m,pep2,"mu_m",1), (dot_product(get_base1(beta2,get_base1(sid_m,pep2,"sid_m",1),"beta2",1),get_base1(pred_sub_m,pep2,"pred_sub_m",1)) + dot_product(get_base1(pred_m,pep2,"pred_m",1),get_base1(U,get_base1(pid_m,pep2,"pid_m",1),"U",1))));
                current_statement_begin__ = 92;
                stan::math::assign(get_base1_lhs(y_m,pep2,"y_m",1), (get_base1(mu_m,pep2,"mu_m",1) + (get_base1(y_m_latent,pep2,"y_m_latent",1) * ita)));
                current_statement_begin__ = 93;
                if (as_bool(logical_eq(respond_dep,1))) {
                    current_statement_begin__ = 93;
                    stan::math::assign(get_base1_lhs(pmiss_m,pep2,"pmiss_m",1), inv_logit((dot_product(alpha,get_base1(pred_miss_m,pep2,"pred_miss_m",1)) + (alpha_response * get_base1(mu_m,pep2,"mu_m",1)))));
                } else {
                    current_statement_begin__ = 94;
                    stan::math::assign(get_base1_lhs(pmiss_m,pep2,"pmiss_m",1), inv_logit(dot_product(alpha,get_base1(pred_miss,pep2,"pred_miss",1))));
                }
                current_statement_begin__ = 96;
                if (as_bool(logical_eq(get_base1(pmiss_m,pep2,"pmiss_m",1),0))) {
                    current_statement_begin__ = 96;
                    stan::math::assign(get_base1_lhs(pmiss_m,pep2,"pmiss_m",1), 0.001);
                }
                current_statement_begin__ = 97;
                if (as_bool(logical_eq(get_base1(pmiss_m,pep2,"pmiss_m",1),1))) {
                    current_statement_begin__ = 97;
                    stan::math::assign(get_base1_lhs(pmiss_m,pep2,"pmiss_m",1), 0.999);
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int k0__ = 0; k0__ < nobs; ++k0__) {
            check_greater_or_equal(function__,"pmiss[k0__]",pmiss[k0__],0);
            check_less_or_equal(function__,"pmiss[k0__]",pmiss[k0__],1);
        }
        for (int k0__ = 0; k0__ < nmiss; ++k0__) {
            check_greater_or_equal(function__,"pmiss_m[k0__]",pmiss_m[k0__],0);
            check_less_or_equal(function__,"pmiss_m[k0__]",pmiss_m[k0__],1);
        }

        // write transformed parameters
        for (int k_1__ = 0; k_1__ < npred; ++k_1__) {
            for (int k_0__ = 0; k_0__ < np; ++k_0__) {
                vars__.push_back(U(k_0__, k_1__));
            }
        }
        for (int k_1__ = 0; k_1__ < npred_sub; ++k_1__) {
            for (int k_0__ = 0; k_0__ < nsid; ++k_0__) {
                vars__.push_back(beta2(k_0__, k_1__));
            }
        }
        for (int k_0__ = 0; k_0__ < npred_miss; ++k_0__) {
            vars__.push_back(alpha[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nobs; ++k_0__) {
            vars__.push_back(mu[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nmiss; ++k_0__) {
            vars__.push_back(mu_m[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nmiss; ++k_0__) {
            vars__.push_back(y_m[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nobs; ++k_0__) {
            vars__.push_back(pmiss[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nmiss; ++k_0__) {
            vars__.push_back(pmiss_m[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities


        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_mmlm_code";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_1__ = 1; k_1__ <= npred; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= np; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "U_latent" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= npred; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "g" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= npred; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= npred; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "pVAR" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "ita";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= npred_miss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_latent" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= npred_miss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= npred_miss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_theta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha_response";
        param_names__.push_back(param_name_stream__.str());
        for (int k_1__ = 1; k_1__ <= npred_sub; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nsid; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta2_latent" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= npred_sub; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta2_theta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= npred_sub; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nsid; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta2_mu" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= nmiss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_m_latent" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= npred; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= np; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "U" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= npred_sub; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nsid; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta2" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= npred_miss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nobs; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nmiss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_m" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nmiss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_m" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nobs; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pmiss" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nmiss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pmiss_m" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_1__ = 1; k_1__ <= npred; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= np; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "U_latent" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= npred; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "g" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (npred + ((npred * (npred - 1)) / 2)); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pVAR" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "ita";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= npred_miss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_latent" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= npred_miss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= npred_miss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_theta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha_response";
        param_names__.push_back(param_name_stream__.str());
        for (int k_1__ = 1; k_1__ <= npred_sub; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nsid; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta2_latent" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= npred_sub; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta2_theta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= npred_sub; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nsid; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta2_mu" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= nmiss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_m_latent" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= npred; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= np; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "U" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= npred_sub; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nsid; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta2" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= npred_miss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nobs; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nmiss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_m" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nmiss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_m" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nobs; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pmiss" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nmiss; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pmiss_m" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }

}; // model

}




#endif
