% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_mlms_json.R
\name{read_mlms_json}
\alias{read_mlms_json}
\title{Read MLMS Data in JSON Format}
\usage{
read_mlms_json(path)
}
\arguments{
\item{path}{'character' string.
Path to the JSON file to read.}
}
\value{
A list of data frame components.
See \code{\link{wells}}, \code{\link{zones}}, and \code{\link{ports}} datasets for example output.
}
\description{
Read Multilevel Monitoring System (MLMS) data in JSON format.
Requires that the \pkg{inldata} package is available.
}
\examples{
l <- system.file("extdata/ex-mlms.json", package = "mlms") |>
  read_mlms_json()
str(l, max.level = 1)
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
