/**
 * @file src/kfn.cpp
 *
 * This is an autogenerated file containing implementations of C++ functions to
 * be called by the R kfn binding.
 */
#include <rcpp_mlpack.h>
#define BINDING_TYPE BINDING_TYPE_R
#include <mlpack/methods/neighbor_search/kfn_main.cpp>

// [[Rcpp::export]]
void kfn_mlpackMain()
{
  mlpackMain();
}

// Any implementations of methods for dealing with model pointers will be put
// below this comment, if needed.

// Get the pointer to a KFNModel parameter.
// [[Rcpp::export]]
SEXP IO_GetParamKFNModelPtr(const std::string& paramName)
{
  return std::move((Rcpp::XPtr<KFNModel>) IO::GetParam<KFNModel*>(paramName));
}

// Set the pointer to a KFNModel parameter.
// [[Rcpp::export]]
void IO_SetParamKFNModelPtr(const std::string& paramName, SEXP ptr)
{
  IO::GetParam<KFNModel*>(paramName) =  Rcpp::as<Rcpp::XPtr<KFNModel>>(ptr);
  IO::SetPassed(paramName);
}

// Serialize a KFNModel pointer.
// [[Rcpp::export]]
Rcpp::RawVector SerializeKFNModelPtr(SEXP ptr)
{
  std::ostringstream oss;
  {
    boost::archive::binary_oarchive oa(oss);
    oa << boost::serialization::make_nvp("KFNModel",
          *Rcpp::as<Rcpp::XPtr<KFNModel>>(ptr));
  }

  Rcpp::RawVector raw_vec(oss.str().size());

  // Copy the string buffer so we can return one that won't get deallocated when
  // we exit this function.
  memcpy(&raw_vec[0], oss.str().c_str(), oss.str().size());
  raw_vec.attr("type") = "KFNModel";
  return raw_vec;
}

// Deserialize a KFNModel pointer.
// [[Rcpp::export]]
SEXP DeserializeKFNModelPtr(Rcpp::RawVector str)
{
  KFNModel* ptr = new KFNModel();

  std::istringstream iss(std::string((char *) &str[0], str.size()));
  {
    boost::archive::binary_iarchive ia(iss);
    ia >> boost::serialization::make_nvp("KFNModel", *ptr);
  }

  // R will be responsible for freeing this.
  return std::move((Rcpp::XPtr<KFNModel>)ptr);
}


