/**
 * @file core/math/math.hpp
 * @author Ryan Curtin
 *
 * Convenience include for all math functionality.
 *
 * mlpack is free software; you may redistribute it and/or modify it under the
 * terms of the 3-clause BSD license.  You should have received a copy of the
 * 3-clause BSD license along with mlpack.  If not, see
 * http://www.opensource.org/licenses/BSD-3-Clause for more information.
 */
#ifndef MLPACK_CORE_MATH_MATH_HPP
#define MLPACK_CORE_MATH_MATH_HPP

#include "ccov.hpp"
#include "clamp.hpp"
#include "columns_to_blocks.hpp"
#include "digamma.hpp"
#include "lin_alg.hpp"
#include "log_add.hpp"
#include "make_alias.hpp"
#include "multiply_slices.hpp"
#include "quantile.hpp"
#include "random_basis.hpp"
#include "random.hpp"
#include "range.hpp"
#include "round.hpp"
#include "shuffle_data.hpp"
#include "trigamma.hpp"

#endif
